/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.mixin;

import com.lumengrid.oritechthings.block.custom.TierAddonBlock;
import com.lumengrid.oritechthings.util.Constants;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorMotorBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.init.BlockContent;

@Mixin(value={AcceleratorControllerBlockEntity.class})
public class AcceleratorMotorInteractionMixin {
    @Shadow
    private AcceleratorParticleLogic.ActiveParticle particle;

    @Inject(method={"handleParticleMotorInteraction"}, at={@At(value="HEAD")})
    private void handleParticleMotorInteraction(BlockPos motorBlock, CallbackInfo ci) {
        if (this.particle == null) {
            return;
        }
        AcceleratorControllerBlockEntity self = (AcceleratorControllerBlockEntity)this;
        assert (self.getLevel() != null);
        BlockEntity entity = self.getLevel().getBlockEntity(motorBlock);
        if (!(entity instanceof AcceleratorMotorBlockEntity)) {
            return;
        }
        AcceleratorMotorBlockEntity motorEntity = (AcceleratorMotorBlockEntity)entity;
        AddonStats addonStats = this.findMotorAddon(motorBlock, self);
        EnergyApi.EnergyStorage storage = motorEntity.getEnergyStorage(null);
        float speed = this.particle.velocity;
        if (addonStats == null) {
            float cost;
            long availableEnergy = storage.getAmount();
            if ((float)availableEnergy >= (cost = speed * (float)Oritech.CONFIG.accelerationRFCost())) {
                storage.extract((long)cost, false);
                storage.update();
                this.particle.velocity += 1.0f;
            }
            return;
        }
        float baseMotorCost = speed * (float)Oritech.CONFIG.accelerationRFCost();
        float additionalVelocity = Math.max(Math.min(addonStats.speedBonus(), 10.0f), 0.0f);
        long totalCost = this.calculateEnergyCost(baseMotorCost, addonStats.energyCostMultiplier());
        long availableEnergy = storage.getAmount();
        if (availableEnergy >= totalCost) {
            storage.extract(totalCost, false);
            storage.update();
            this.particle.velocity += 1.0f + additionalVelocity;
        }
    }

    @Unique
    private AddonStats findMotorAddon(BlockPos motorPos, AcceleratorControllerBlockEntity controller) {
        BlockPos addonPos = motorPos.below();
        assert (controller.getLevel() != null);
        BlockState addonState = controller.getLevel().getBlockState(addonPos);
        Block addonBlock = addonState.getBlock();
        if (addonBlock instanceof TierAddonBlock) {
            TierAddonBlock tieredAddon = (TierAddonBlock)addonBlock;
            Constants.AddonType addonType = (Constants.AddonType)((Object)addonState.getValue(TierAddonBlock.ADDON_TYPE));
            if (addonType == Constants.AddonType.SPEED || addonType == Constants.AddonType.EFFICIENCY || addonType == Constants.AddonType.EFFICIENT_SPEED) {
                MachineAddonBlock.AddonSettings addonSettings = this.getAddonSettings(tieredAddon);
                float speedBonus = this.calculateSpeedBonus(addonSettings.speedMultiplier());
                float energyCostMultiplier = addonSettings.efficiencyMultiplier();
                return new AddonStats(speedBonus, energyCostMultiplier);
            }
        }
        if (addonBlock instanceof MachineAddonBlock) {
            MachineAddonBlock normalAddon = (MachineAddonBlock)addonBlock;
            if (addonBlock.equals(BlockContent.MACHINE_SPEED_ADDON) || addonBlock.equals(BlockContent.MACHINE_EFFICIENCY_ADDON) || addonBlock.equals(BlockContent.MACHINE_ULTIMATE_ADDON)) {
                MachineAddonBlock.AddonSettings addonSettings = this.getAddonSettings(normalAddon);
                float speedBonus = this.calculateSpeedBonus(addonSettings.speedMultiplier());
                float energyCostMultiplier = addonSettings.efficiencyMultiplier();
                return new AddonStats(speedBonus, energyCostMultiplier);
            }
        }
        return null;
    }

    @Unique
    private MachineAddonBlock.AddonSettings getAddonSettings(MachineAddonBlock addonBlock) {
        try {
            Field field = MachineAddonBlock.class.getDeclaredField("addonSettings");
            field.setAccessible(true);
            return (MachineAddonBlock.AddonSettings)field.get(addonBlock);
        }
        catch (Exception e) {
            return MachineAddonBlock.AddonSettings.getDefaultSettings();
        }
    }

    @Unique
    private float calculateSpeedBonus(float speedMultiplier) {
        return 1.0f - speedMultiplier;
    }

    @Unique
    private long calculateEnergyCost(double baseCost, float efficiencyMultiplier) {
        return (long)(baseCost * (double)Math.max(efficiencyMultiplier, 0.0f));
    }

    @Unique
    private record AddonStats(float speedBonus, float energyCostMultiplier) {
    }
}

