/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.datagen;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.manmaed.petrock.entity.PREntityTypes;
import net.manmaed.petrock.item.PRItems;
import net.manmaed.petrock.libs.RLHelper;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class PRAdvancementProvider
extends AdvancementProvider {
    public PRAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new PRAdvancementGenerator()));
    }

    public static class PRAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider lookups, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display(PRAdvancementGenerator.makeRootInfo((Item)PRItems.PETROCKBOX.get(), "stone", true)).addCriterion("get_pick_to_mine_stoneium", PRAdvancementGenerator.inventoryChangedTrigger(Items.STONE_PICKAXE)).save(consumer, PRAdvancementGenerator.getSaveLoc("root"));
            AdvancementHolder mineStoneium = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.RAW_STONEIUM.get(), "mine_stoneium", AdvancementType.TASK, true, true, false)).parent(root).addCriterion("get_raw_stoneium", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.RAW_STONEIUM.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("mine_stoneium"));
            AdvancementHolder cookStoneiun = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.STONEIUM.get(), "cook_raw_stoneium", AdvancementType.TASK, true, true, false)).parent(mineStoneium).addCriterion("cook_raw_stoneium", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.STONEIUM.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("cook_raw_stoneium"));
            AdvancementHolder orderPetRock = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.ORDER_FORM.get(), "order_form", AdvancementType.TASK, true, true, false)).parent(root).addCriterion("order_form", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.ORDER_FORM.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("order_form"));
            AdvancementHolder petrockget = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.PETROCKBOX.get(), "get_petrock", AdvancementType.GOAL, true, true, false)).parent(orderPetRock).addCriterion("get_petrock", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.PETROCKBOX.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("get_petrock"));
            AdvancementHolder petrockwithlegs = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.PETROCKWITHLEGSBOX.get(), "get_petrock_with_legs", AdvancementType.GOAL, true, true, false)).parent(orderPetRock).addCriterion("get_petrock_with_legs", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.PETROCKWITHLEGSBOX.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("get_petrock_with_legs"));
            AdvancementHolder killpetrock = Advancement.Builder.advancement().display(PRAdvancementGenerator.info(Items.DIAMOND_SWORD, "warranty_void", AdvancementType.CHALLENGE, true, true, true)).parent(petrockget).addCriterion("kill_petrock", PRAdvancementGenerator.killEntityTrigger((EntityType)PREntityTypes.PETROCK.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("petrock_warranty_void"));
            AdvancementHolder killpetrocwithlegs = Advancement.Builder.advancement().display(PRAdvancementGenerator.info(Items.DIAMOND_SWORD, "warranty_void", AdvancementType.CHALLENGE, true, true, true)).parent(petrockwithlegs).addCriterion("kill_petrock_with_legs", PRAdvancementGenerator.killEntityTrigger((EntityType)PREntityTypes.PETROCKWITHLEGS.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("petrock_with_legs_warranty_void"));
            AdvancementHolder healpetrock = Advancement.Builder.advancement().display(PRAdvancementGenerator.info((Item)PRItems.KIBBLE.get(), "heal_a_petrock", AdvancementType.GOAL, true, true, false)).parent(orderPetRock).addCriterion("make_kibble", PRAdvancementGenerator.inventoryChangedTrigger((Item)PRItems.KIBBLE.get())).save(consumer, PRAdvancementGenerator.getSaveLoc("heal_a_petrok"));
        }

        protected static DisplayInfo makeRootInfo(Item icon, String blockToDisplay, Boolean isMineCraft) {
            return new DisplayInfo(new ItemStack((ItemLike)icon), (Component)Component.translatable((String)PRAdvancementGenerator.title("root")), (Component)Component.translatable((String)PRAdvancementGenerator.desc("root")), Optional.of(PRAdvancementGenerator.getBackground(isMineCraft, blockToDisplay)), AdvancementType.TASK, false, false, false);
        }

        protected static DisplayInfo info(Item icon, String advancemntName, AdvancementType advancementType, Boolean showToast, Boolean announceChat, Boolean shouldBeHidden) {
            return new DisplayInfo(new ItemStack((ItemLike)icon), (Component)Component.translatable((String)PRAdvancementGenerator.title(advancemntName)), (Component)Component.translatable((String)PRAdvancementGenerator.desc(advancemntName)), Optional.empty(), advancementType, showToast.booleanValue(), announceChat.booleanValue(), shouldBeHidden.booleanValue());
        }

        protected static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryChangedTrigger(Item item) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()});
        }

        protected static Criterion<KilledTrigger.TriggerInstance> killEntityTrigger(EntityType entity) {
            return KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entity));
        }

        private static String getSaveLoc(String saveLoc) {
            return RLHelper.location(saveLoc).toString();
        }

        private static String title(String name) {
            return "advancements.petrock." + name + ".title";
        }

        private static String desc(String name) {
            return "advancements.petrock." + name + ".description";
        }

        private static ResourceLocation getBackground(Boolean isMCBackground, String backgroundName) {
            if (isMCBackground.booleanValue()) {
                return ResourceLocation.withDefaultNamespace((String)("textures/block/" + backgroundName + ".png"));
            }
            return RLHelper.location("textures/block/" + backgroundName + ".png");
        }
    }
}

