/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.xnet;

import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.List;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class XNetCompatibility
implements IPlacer {
    public static Class<? extends Block> getBlockToRegister() {
        return GenericCableBlock.class;
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> adjacentDirectionSides, ItemStack heldPipeItem) {
        Block block = Block.byItem((Item)item);
        String id = item.getDescriptionId();
        String[] idParts = id.splitWithDelimiters("_", 3);
        String colorId = idParts[idParts.length - 1];
        CableColor color = CableColor.valueOf((String)colorId.toUpperCase());
        if (block instanceof GenericCableBlock) {
            BlockHitResult hitResult;
            BlockPlaceContext context;
            BlockState blockState;
            boolean placed;
            GenericCableBlock colorBlock = (GenericCableBlock)block;
            if (!GeneralUtils.isVoidableBlock(level, pos)) {
                BlockState state = level.getBlockState(pos);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)heldPipeItem);
                    for (ItemStack drop : drops) {
                        if (player.getInventory().add(drop)) continue;
                        player.drop(drop, false);
                    }
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.05);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                level.removeBlock(pos, false);
            }
            if (placed = level.setBlockAndUpdate(pos, blockState = colorBlock.calculateState((LevelAccessor)(context = new BlockPlaceContext(level, player, InteractionHand.OFF_HAND, heldPipeItem, hitResult = new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), adjacentDirectionSides.getFirst(), pos, false))).getLevel(), context.getClickedPos(), (BlockState)colorBlock.defaultBlockState().setValue((Property)GenericCableBlock.COLOR, (Comparable)color)))) {
                blockState.getBlock().setPlacedBy(level, pos, blockState, (LivingEntity)player, heldPipeItem);
            }
            return placed;
        }
        return false;
    }
}

