/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.items;

import com.heaser.pipeconnector.ModSounds;
import com.heaser.pipeconnector.client.proxy.GeneralClientProxy;
import com.heaser.pipeconnector.client.proxy.IClientProxy;
import com.heaser.pipeconnector.client.proxy.items.IPipeConnectorItemProxy;
import com.heaser.pipeconnector.client.proxy.items.PipeConnectorItemProxy;
import com.heaser.pipeconnector.compatibility.CompatibilityDirectionGetter;
import com.heaser.pipeconnector.particles.ParticleHelper;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeConnectorItem
extends Item {
    private IPipeConnectorItemProxy itemProxy = null;
    private IClientProxy clientProxy = null;

    public PipeConnectorItem(Item.Properties properties) {
        super(properties);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.itemProxy = new PipeConnectorItemProxy();
            this.clientProxy = new GeneralClientProxy();
        }
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        CompoundTag tag = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        TagUtils.setCustomModelData(tag, GeneralUtils.isAprilFoolsDay());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide() || this.itemProxy == null) {
            return InteractionResultHolder.pass((Object)heldItem);
        }
        HitResult targetHitResult = player.pick(player.blockInteractionRange() - 1.0, 0.0f, false);
        Vec3 targetPosition = targetHitResult.getLocation();
        BlockPos targetBlockPos = new BlockPos((int)targetPosition.x, (int)targetPosition.y, (int)targetPosition.z);
        boolean isTargetBlockAir = level.getBlockState(targetBlockPos).isAir();
        boolean isShiftKeyHeld = player.isShiftKeyDown();
        if (hand == InteractionHand.MAIN_HAND && isShiftKeyHeld && isTargetBlockAir) {
            this.itemProxy.openPipeConnectorGui(heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack interactedItem = context.getItemInHand();
        this.handleCommonUseOn(interactedItem);
        if (GeneralUtils.isServerSide(level)) {
            return this.handleServerSideUseOn(context);
        }
        return InteractionResult.FAIL;
    }

    private void handleCommonUseOn(ItemStack interactedItem) {
        int depth = TagUtils.getDepthFromStack(interactedItem);
        if (depth == -1) {
            TagUtils.setDepthToStack(interactedItem, 2);
        }
    }

    private InteractionResult handleServerSideUseOn(UseOnContext context) {
        Player usingPlayer = context.getPlayer();
        Level level = context.getLevel();
        ItemStack interactedItem = context.getItemInHand();
        BlockPos clickedPosition = context.getClickedPos();
        Direction clickedFace = CompatibilityDirectionGetter.getInstance().getDirection(context);
        if (usingPlayer == null) {
            return InteractionResult.FAIL;
        }
        boolean isShiftKeyDown = usingPlayer.isShiftKeyDown();
        BlockPos relativePosition = clickedPosition;
        if (clickedFace != null) {
            relativePosition = clickedPosition.relative(clickedFace);
        }
        if (isShiftKeyDown) {
            if (!GeneralUtils.isPlaceableBlock(usingPlayer)) {
                usingPlayer.displayClientMessage((Component)Component.translatable((String)"item.pipe_connector.message.holdValidItem").withStyle(ChatFormatting.GOLD), true);
                return InteractionResult.FAIL;
            }
            if (clickedFace == Direction.UP) {
                usingPlayer.displayClientMessage((Component)Component.translatable((String)"item.pipe_connector.message.UpSideNotAllowed").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), true);
                return InteractionResult.FAIL;
            }
            List<NodeParameter> currentNodes = TagUtils.getNodesFromStack(interactedItem);
            NodeParameter newNode = new NodeParameter(clickedPosition, clickedFace);
            boolean hasReachedMaxNodes = GeneralUtils.MaxAllowedNodesReached(currentNodes);
            if (currentNodes.stream().anyMatch(node -> node.position.equals((Object)newNode.position))) {
                GeneralUtils.handleNodeRemovalByPosition(currentNodes, newNode.position, interactedItem);
                ParticleHelper.serverSpawnMarkerParticle((ServerLevel)level, newNode.position);
                level.playSound(null, newNode.position, ModSounds.nextAlternating(usingPlayer.getUUID()), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (hasReachedMaxNodes) {
                usingPlayer.displayClientMessage((Component)Component.translatable((String)"item.pipe_connector.message.maxNodesReached").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), true);
                return InteractionResult.FAIL;
            }
            if (!level.dimensionTypeRegistration().getRegisteredName().equals(TagUtils.getDimension(interactedItem))) {
                currentNodes.clear();
            }
            currentNodes.add(newNode);
            TagUtils.setDimension(interactedItem, level.dimensionTypeRegistration().getRegisteredName());
            ParticleHelper.serverSpawnMarkerParticle((ServerLevel)level, relativePosition);
            TagUtils.setNodesToStack(interactedItem, currentNodes);
            level.playSound(null, relativePosition, ModSounds.nextAlternating(usingPlayer.getUUID()), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (this.clientProxy != null) {
            if (this.clientProxy.hasShiftDown()) {
                pTooltipComponents.add((Component)Component.translatable((String)"item.pipe_connector.tooltip.usageExplanation").withStyle(ChatFormatting.DARK_AQUA));
                pTooltipComponents.add((Component)Component.translatable((String)"item.pipe_connector.tooltip.openGui").withStyle(ChatFormatting.BLUE));
                pTooltipComponents.add((Component)Component.translatable((String)"item.pipe_connector.tooltip.changeDepthExplanation").withStyle(ChatFormatting.LIGHT_PURPLE));
            } else {
                pTooltipComponents.add((Component)Component.translatable((String)"item.pipe_connector.tooltip.shiftForMoreInfo").withStyle(ChatFormatting.GOLD));
            }
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

