/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data;

import com.davenonymous.pipegoggles.config.Rules;
import com.davenonymous.pipegoggles.data.EnumGoggleMode;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;

public class EnergyCosts {
    public static long getCost(PipeGoggleDataComponent data) {
        if (!Rules.requireEnergy) {
            return 0L;
        }
        if (data.isDisabled()) {
            return 0L;
        }
        if (data.enabledColors().isEmpty()) {
            return 0L;
        }
        long rangeCost = (long)data.range() * (long)Rules.energyPerRange;
        long colorCost = (long)data.enabledColors().size() * (long)Rules.energyPerActiveColor;
        if (data.goggleMode() == EnumGoggleMode.ON) {
            colorCost = (long)((float)colorCost * 1.5f);
            rangeCost = (long)((float)rangeCost * 1.5f);
        }
        return rangeCost + colorCost;
    }
}

