/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data.cache;

import com.davenonymous.pipegoggles.PipeGoggles;
import com.davenonymous.pipegoggles.data.GoggleSupport;
import com.davenonymous.pipegoggles.setup.ModRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;

@EventBusSubscriber(modid="pipegoggles")
public class GoggleSupportCache {
    public static final Map<Block, GoggleSupport> SUPPORT_BY_BLOCK = new HashMap<Block, GoggleSupport>();
    public static final Map<Item, GoggleSupport> SUPPORT_BY_ITEM_TRIGGERS = new HashMap<Item, GoggleSupport>();
    public static final Map<GoggleSupport, List<Block>> BLOCKS_BY_SUPPORT = new HashMap<GoggleSupport, List<Block>>();
    public static final Map<GoggleSupport, List<Item>> ITEMS_BY_SUPPORT = new HashMap<GoggleSupport, List<Item>>();
    public static final Map<GoggleSupport, List<Class<?>>> BLOCK_CLASSES_BY_SUPPORT = new HashMap();

    @SubscribeEvent
    public static void dataMapsUpdated(DataMapsUpdatedEvent event) {
        event.ifRegistry(Registries.BLOCK, blockRegistry -> {
            Optional optRegistry = event.getRegistries().registry(ModRegistries.GOGGLE_SUPPORT_REGISTRY_KEY);
            if (optRegistry.isEmpty()) {
                PipeGoggles.LOGGER.warn("No GoggleSupport registry found. Goggles will not work with any blocks.");
                return;
            }
            SUPPORT_BY_BLOCK.clear();
            SUPPORT_BY_ITEM_TRIGGERS.clear();
            BLOCKS_BY_SUPPORT.clear();
            ITEMS_BY_SUPPORT.clear();
            BLOCK_CLASSES_BY_SUPPORT.clear();
            for (Map.Entry entry : ((Registry)optRegistry.get()).entrySet()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                String group = key.location().getPath();
                GoggleSupport support = (GoggleSupport)entry.getValue();
                int blockCount = 0;
                int triggerItemCount = 0;
                for (Block block : support.blocks().getAllBlocks((Registry<Block>)blockRegistry)) {
                    Item blockItem;
                    SUPPORT_BY_BLOCK.put(block, support);
                    BLOCKS_BY_SUPPORT.computeIfAbsent(support, k -> new ArrayList()).add(block);
                    ++blockCount;
                    if (!support.useBlockItems() || (blockItem = block.asItem()) == null) continue;
                    SUPPORT_BY_ITEM_TRIGGERS.put(blockItem, support);
                    ITEMS_BY_SUPPORT.computeIfAbsent(support, k -> new ArrayList()).add(blockItem);
                    ++triggerItemCount;
                }
                for (Item item : support.getAllItems((Registry<Item>)((Registry)event.getRegistries().registry(Registries.ITEM).get()))) {
                    SUPPORT_BY_ITEM_TRIGGERS.put(item, support);
                    ITEMS_BY_SUPPORT.computeIfAbsent(support, k -> new ArrayList()).add(item);
                    ++triggerItemCount;
                }
                PipeGoggles.LOGGER.info("Group '{}' has {} block{} and {} item{} with goggle support", new Object[]{group, blockCount, blockCount == 1 ? "" : "s", triggerItemCount, triggerItemCount == 1 ? "" : "s"});
            }
        });
    }

    public static Optional<GoggleSupport> getSupportFor(ItemStack stack) {
        if (!SUPPORT_BY_ITEM_TRIGGERS.containsKey(stack.getItem())) {
            return Optional.empty();
        }
        GoggleSupport support = SUPPORT_BY_ITEM_TRIGGERS.get(stack.getItem());
        return Optional.of(support);
    }

    public static boolean isSupportedMod(ItemStack stack) {
        return GoggleSupportCache.getSupportFor(stack).isPresent();
    }
}

