/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.items;

import com.davenonymous.pipegoggles.config.Client;
import com.davenonymous.pipegoggles.config.Rules;
import com.davenonymous.pipegoggles.data.EnergyCosts;
import com.davenonymous.pipegoggles.data.EnumGoggleMode;
import com.davenonymous.pipegoggles.data.cache.GoggleSupportCache;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.items.PipeGoggleContainer;
import com.davenonymous.pipegoggles.items.PipeGoggleItem;
import com.davenonymous.pipegoggles.lib.gui.GUI;
import com.davenonymous.pipegoggles.lib.gui.Icons;
import com.davenonymous.pipegoggles.lib.gui.WidgetContainer;
import com.davenonymous.pipegoggles.lib.gui.WidgetContainerScreen;
import com.davenonymous.pipegoggles.lib.gui.event.GuiDataUpdatedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.ValueChangedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.tooltip.HBoxTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.LineSeparatorTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.NumberWithUnitTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.WrappedStringTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetIconSelect;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetLabel;
import com.davenonymous.pipegoggles.networking.SetAlphaPacket;
import com.davenonymous.pipegoggles.networking.SetLineWidthPacket;
import com.davenonymous.pipegoggles.networking.SetModePacket;
import com.davenonymous.pipegoggles.networking.SetRangePacket;
import com.davenonymous.pipegoggles.render.WidgetColoredGhostSlot;
import com.davenonymous.pipegoggles.render.WidgetSelectBar;
import com.davenonymous.pipegoggles.render.WidgetTank;
import com.davenonymous.pipegoggles.setup.ModDataComponents;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class PipeGoggleScreen
extends WidgetContainerScreen<PipeGoggleContainer> {
    WidgetIconSelect<Integer> alphaSelect;
    WidgetIconSelect<Integer> lineWidthSelect;
    WidgetIconSelect<EnumGoggleMode> enabledCheckBox;
    WidgetSelectBar<Integer> rangeSelect;
    WidgetTank tank;

    public PipeGoggleScreen(PipeGoggleContainer container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    @Override
    protected GUI createGUI() {
        GUI gui = new GUI(0, 0, PipeGoggleContainer.WIDTH, PipeGoggleContainer.HEIGHT);
        gui.setContainer((WidgetContainer)this.menu);
        WidgetLabel label = new WidgetLabel(I18n.get((String)"container.pipegoggles.pipegoggles", (Object[])new Object[0]));
        label.setTextColor(-12632257);
        label.setPosition(8, 6);
        gui.add(label);
        ItemStack goggles = Minecraft.getInstance().player.getMainHandItem();
        if (!(goggles.getItem() instanceof PipeGoggleItem)) {
            return gui;
        }
        PipeGoggleDataComponent dataComponent = (PipeGoggleDataComponent)goggles.get(ModDataComponents.PIPEGOGGLES_COMPONENT);
        if (dataComponent == null) {
            dataComponent = new PipeGoggleDataComponent();
        }
        int xOffset = 8;
        int yOffset = 18;
        this.lineWidthSelect = new WidgetIconSelect();
        this.lineWidthSelect.setSize(13, 12);
        this.lineWidthSelect.setTextureSize(13.0f, 12.0f);
        this.lineWidthSelect.addChoiceWithSprite(1, new WidgetIconSelect.IconData(Icons.lineWidth1, 13, 12));
        this.lineWidthSelect.addChoiceWithSprite(2, new WidgetIconSelect.IconData(Icons.lineWidth2, 13, 12));
        this.lineWidthSelect.addChoiceWithSprite(3, new WidgetIconSelect.IconData(Icons.lineWidth3, 13, 12));
        this.lineWidthSelect.setValue(dataComponent.lineWidth());
        this.lineWidthSelect.setPosition(gui.width - 58, 4);
        this.lineWidthSelect.addListener(ValueChangedEvent.class, (event, widget) -> {
            Object patt0$temp = event.newValue;
            if (!(patt0$temp instanceof Integer)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            Integer newLineWidth = (Integer)patt0$temp;
            this.updateTooltips();
            PacketDistributor.sendToServer((CustomPacketPayload)new SetLineWidthPacket(newLineWidth), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(this.lineWidthSelect);
        this.alphaSelect = new WidgetIconSelect();
        this.alphaSelect.setSize(13, 12);
        this.alphaSelect.setTextureSize(13.0f, 12.0f);
        this.alphaSelect.addChoiceWithSprite(51, new WidgetIconSelect.IconData(Icons.alpha20, 13, 12));
        this.alphaSelect.addChoiceWithSprite(102, new WidgetIconSelect.IconData(Icons.alpha40, 13, 12));
        this.alphaSelect.addChoiceWithSprite(153, new WidgetIconSelect.IconData(Icons.alpha60, 13, 12));
        this.alphaSelect.addChoiceWithSprite(204, new WidgetIconSelect.IconData(Icons.alpha80, 13, 12));
        this.alphaSelect.addChoiceWithSprite(255, new WidgetIconSelect.IconData(Icons.alpha100, 13, 12));
        this.alphaSelect.setValue(dataComponent.alpha());
        this.alphaSelect.setPosition(gui.width - 44, 4);
        this.alphaSelect.addListener(ValueChangedEvent.class, (event, widget) -> {
            Object patt0$temp = event.newValue;
            if (!(patt0$temp instanceof Integer)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            Integer newAlpha = (Integer)patt0$temp;
            this.updateTooltips();
            PacketDistributor.sendToServer((CustomPacketPayload)new SetAlphaPacket(newAlpha), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(this.alphaSelect);
        this.enabledCheckBox = new WidgetIconSelect();
        this.enabledCheckBox.setSize(20, 12);
        this.enabledCheckBox.setTextureSize(20.0f, 12.0f);
        this.enabledCheckBox.addChoiceWithSprite(EnumGoggleMode.OFF, new WidgetIconSelect.IconData(Icons.toggleOff, 20, 12));
        this.enabledCheckBox.addChoiceWithSprite(EnumGoggleMode.ON, new WidgetIconSelect.IconData(Icons.toggleOn, 20, 12));
        this.enabledCheckBox.addChoiceWithSprite(EnumGoggleMode.SMART, new WidgetIconSelect.IconData(Icons.toggleAuto, 20, 12));
        this.enabledCheckBox.setValue(dataComponent.goggleMode());
        this.enabledCheckBox.setPosition(gui.width - 26, 4);
        this.enabledCheckBox.addListener(ValueChangedEvent.class, (event, widget) -> {
            Object patt0$temp = event.newValue;
            if (!(patt0$temp instanceof EnumGoggleMode)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            EnumGoggleMode newMode = (EnumGoggleMode)((Object)((Object)patt0$temp));
            this.updateTooltips();
            PacketDistributor.sendToServer((CustomPacketPayload)new SetModePacket(newMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(this.enabledCheckBox);
        int maxCols = 8;
        int col = 0;
        for (DyeColor color : DyeColor.values()) {
            WidgetColoredGhostSlot ghostSlot = new WidgetColoredGhostSlot(color);
            ghostSlot.setIsValidItemStack(stack -> {
                if (!GoggleSupportCache.isSupportedMod(stack)) {
                    return false;
                }
                ItemStack goggle = Minecraft.getInstance().player.getMainHandItem();
                PipeGoggleDataComponent data = PipeGoggleItem.data(goggle);
                Optional<DyeColor> optSlotColor = data.getColorForStack((ItemStack)stack);
                return optSlotColor.isEmpty();
            });
            ghostSlot.setGrayOut(!dataComponent.isColorEnabled(color));
            ghostSlot.addListener(ValueChangedEvent.class, (event, widget) -> {
                ItemStack goggle = Minecraft.getInstance().player.getMainHandItem();
                PipeGoggleDataComponent data = PipeGoggleItem.data(goggle);
                if (data.getStackForColor(color).isPresent()) {
                    if (data.isColorEnabled(color)) {
                        ghostSlot.addTooltipElement(StringTooltipComponent.orange(I18n.get((String)"pipegoggles.message.click_to_disable", (Object[])new Object[0])));
                    } else {
                        ghostSlot.addTooltipElement(StringTooltipComponent.green(I18n.get((String)"pipegoggles.message.click_to_enable", (Object[])new Object[0])));
                    }
                    ghostSlot.addTooltipElement(StringTooltipComponent.chat(I18n.get((String)"pipegoggles.message.right_click_to_remove", (Object[])new Object[0]), ChatFormatting.RED));
                } else if (Client.showHelpTooltips) {
                    ghostSlot.addTooltipElement(StringTooltipComponent.gray(I18n.get((String)"pipegoggles.help.insert_items", (Object[])new Object[0])));
                }
                return WidgetEventResult.CONTINUE_PROCESSING;
            });
            if (dataComponent.getStackForColor(color).isPresent()) {
                ghostSlot.setValueForced(dataComponent.getStackForColor(color).get());
                ghostSlot.updateTooltips();
            }
            ghostSlot.setPosition(xOffset, yOffset);
            gui.add(ghostSlot);
            xOffset += 18;
            if (++col < maxCols) continue;
            col = 0;
            xOffset = 8;
            yOffset += 18;
        }
        this.rangeSelect = new WidgetSelectBar();
        this.rangeSelect.setPosition(8, yOffset + 2);
        this.rangeSelect.setSize(gui.width - 16 - 18, 22);
        this.rangeSelect.addChoice((Collection<Integer>)Rules.rangeOptions);
        this.rangeSelect.setPositionProvider(integer -> Float.valueOf((float)(integer - Rules.minRange) / (float)(Rules.maxRange - Rules.minRange)));
        this.rangeSelect.setValue((int)dataComponent.range());
        this.rangeSelect.addListener(ValueChangedEvent.class, (event, widget) -> {
            Object patt0$temp = event.newValue;
            if (!(patt0$temp instanceof Integer)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            Integer newRange = (Integer)patt0$temp;
            PacketDistributor.sendToServer((CustomPacketPayload)new SetRangePacket(newRange.intValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(this.rangeSelect);
        this.tank = new WidgetTank(Long.valueOf(Rules.maxEnergy));
        this.tank.setSize(12, 60);
        this.tank.setPosition(gui.width - 18, 17);
        this.tank.setValue(dataComponent.storedEnergy());
        this.tank.setVisible(Rules.requireEnergy);
        gui.add(this.tank);
        gui.addListener(GuiDataUpdatedEvent.class, (event, widget) -> {
            ItemStack goggle = Minecraft.getInstance().player.getMainHandItem();
            PipeGoggleDataComponent data = (PipeGoggleDataComponent)goggle.get(ModDataComponents.PIPEGOGGLES_COMPONENT);
            this.tank.setValue(data.storedEnergy());
            this.updateTooltips();
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.fireDataUpdateEvent();
        return gui;
    }

    public void updateTooltips() {
        ItemStack goggle = Minecraft.getInstance().player.getMainHandItem();
        PipeGoggleDataComponent data = (PipeGoggleDataComponent)goggle.get(ModDataComponents.PIPEGOGGLES_COMPONENT);
        EnumGoggleMode newMode = (EnumGoggleMode)((Object)this.enabledCheckBox.getValue());
        if (newMode == EnumGoggleMode.ON) {
            this.enabledCheckBox.setTooltipElements(WrappedStringTooltipComponent.orange(I18n.get((String)"pipegoggles.message.always_on", (Object[])new Object[0])));
        } else if (newMode == EnumGoggleMode.OFF) {
            this.enabledCheckBox.setTooltipElements(WrappedStringTooltipComponent.red(I18n.get((String)"pipegoggles.message.always_off", (Object[])new Object[0])));
        } else {
            this.enabledCheckBox.setTooltipElements(WrappedStringTooltipComponent.green(I18n.get((String)"pipegoggles.message.auto_mode", (Object[])new Object[0])));
            if (Client.autoModeRequiresCrouching) {
                this.enabledCheckBox.addTooltipElement(StringTooltipComponent.gray(I18n.get((String)"pipegoggles.message.auto_mode_crouch", (Object[])new Object[0])));
            }
        }
        if (Client.showHelpTooltips) {
            this.rangeSelect.setTooltipElements(StringTooltipComponent.gray(I18n.get((String)"pipegoggles.help.set_range", (Object[])new Object[0])));
        }
        HBoxTooltipComponent alphaTooltip = new HBoxTooltipComponent(StringTooltipComponent.white(I18n.get((String)"pipegoggles.message.opacity", (Object[])new Object[0])), StringTooltipComponent.gray(String.format("%.0f%%", Float.valueOf((float)((Integer)this.alphaSelect.getValue()).intValue() / 255.0f * 100.0f))));
        this.alphaSelect.setTooltipElements(alphaTooltip);
        HBoxTooltipComponent lineWidthTooltip = new HBoxTooltipComponent(StringTooltipComponent.white(I18n.get((String)"pipegoggles.message.line_width", (Object[])new Object[0])), StringTooltipComponent.gray(String.valueOf(this.lineWidthSelect.getValue())));
        this.lineWidthSelect.setTooltipElements(lineWidthTooltip);
        int color = -12010692;
        if ((double)((Long)this.tank.getValue()).longValue() < (double)Rules.maxEnergy * 0.2) {
            color = ChatFormatting.RED.getColor();
        } else if ((double)((Long)this.tank.getValue()).longValue() < (double)Rules.maxEnergy * 0.5) {
            color = -1658112;
        }
        this.tank.setTooltipElements(StringTooltipComponent.white(I18n.get((String)"pipegoggles.message.stored_energy", (Object[])new Object[0])), new HBoxTooltipComponent(new NumberWithUnitTooltipComponent((Long)this.tank.getValue(), color), StringTooltipComponent.gray("/"), new NumberWithUnitTooltipComponent(Rules.maxEnergy, -12010692), StringTooltipComponent.gray(" FE")).setPadding(0));
        long costs = EnergyCosts.getCost(data);
        if (data.storedEnergy() >= costs && costs > 0L) {
            this.tank.addTooltipElement(StringTooltipComponent.orange("-" + costs + " FE/t"));
        }
        if (Client.showHelpTooltips) {
            this.tank.addTooltipElement(new LineSeparatorTooltipComponent(this.tank));
            this.tank.addTooltipElement(new WrappedStringTooltipComponent(I18n.get((String)"pipegoggles.help.keep_powered", (Object[])new Object[0]), ChatFormatting.GRAY.getColor(), 150));
        }
    }
}

