/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.tooltip;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final Ingredient items;
    private boolean showLabel = true;

    public IngredientTooltipComponent(Ingredient items) {
        this.items = items;
    }

    public Ingredient getStack() {
        return this.items;
    }

    public IngredientTooltipComponent setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        return this;
    }

    public int getHeight() {
        return 16;
    }

    public int getWidth(Font font) {
        if (!this.showLabel) {
            return 16;
        }
        ItemStack item = this.activeItem();
        return 18 + font.width((FormattedText)item.getHoverName());
    }

    private ItemStack activeItem() {
        long time = Minecraft.getInstance().level.getGameTime();
        long displayTime = time >> 4;
        ItemStack[] items = this.items.getItems();
        if (items.length == 0) {
            return ItemStack.EMPTY;
        }
        int i = (int)(displayTime % (long)items.length);
        return items[i];
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        ItemStack item = this.activeItem();
        guiGraphics.renderItem(item, x, y);
        guiGraphics.renderItemDecorations(font, item, x, y);
        if (this.showLabel) {
            guiGraphics.drawString(font, item.getHoverName(), x + 18, y + 4, 0xFFFFFF);
        }
    }
}

