/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.widgets;

import com.davenonymous.pipegoggles.lib.gui.event.MouseClickEvent;
import com.davenonymous.pipegoggles.lib.gui.event.ValueChangedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetButton;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetInputField;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetPanelWithValue;

public class WidgetIntegerSelect
extends WidgetPanelWithValue<Integer> {
    WidgetButton less;
    WidgetButton more;
    WidgetInputField input = new WidgetInputField();
    private int number;

    public WidgetIntegerSelect(int min, int max, int init) {
        this(min, max, init, "");
    }

    public WidgetIntegerSelect(int min, int max, int init, String suffix) {
        super(init);
        this.input.setValidator(s -> {
            int enteredValue;
            boolean validChars = s.matches("^[0-9]*$");
            if (validChars && s.length() > 0 && ((enteredValue = Integer.parseInt(s)) < min || enteredValue > max)) {
                return false;
            }
            return validChars;
        });
        this.input.addListener(ValueChangedEvent.class, (event, widget) -> {
            String newValue = (String)event.newValue;
            this.number = newValue == null || newValue.length() == 0 ? 0 : Integer.parseInt(newValue);
            return WidgetEventResult.HANDLED;
        });
        this.less = new WidgetButton("-");
        this.less.addListener(MouseClickEvent.class, (event, widget) -> {
            if (this.number - 1 >= min) {
                this.setNumber(this.number - 1);
            }
            return WidgetEventResult.HANDLED;
        });
        this.more = new WidgetButton("+");
        this.more.addListener(MouseClickEvent.class, (event, widget) -> {
            if (this.number + 1 <= max) {
                this.setNumber(this.number + 1);
            }
            return WidgetEventResult.HANDLED;
        });
        this.add(this.less);
        this.add(this.input);
        this.add(this.more);
        this.setNumber(init);
    }

    protected void setNumber(int number) {
        int oldNumber = this.number;
        this.number = number;
        this.input.setText("" + this.number);
        this.fireEvent(new ValueChangedEvent<Integer>(oldNumber, this.number));
    }

    @Override
    public WidgetIntegerSelect setSize(int width, int height) {
        super.setSize(width, height);
        int buttonWidth = 10;
        this.less.setDimensions(0, -1, buttonWidth, height + 2);
        this.input.setDimensions(buttonWidth + 2, 0, width - (2 * buttonWidth + 4), height);
        this.more.setDimensions(width - buttonWidth, -1, buttonWidth, height + 2);
        return this;
    }

    @Override
    public Integer getValue() {
        return this.number;
    }

    @Override
    public void setValue(Integer value) {
        this.setNumber(value);
    }
}

