/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.render;

import com.davenonymous.pipegoggles.config.Client;
import com.davenonymous.pipegoggles.data.EnumGoggleMode;
import com.davenonymous.pipegoggles.data.cache.BoxLineCache;
import com.davenonymous.pipegoggles.data.cache.BoxOptimizer;
import com.davenonymous.pipegoggles.datacomponents.PipeGoggleDataComponent;
import com.davenonymous.pipegoggles.items.PipeGoggleItem;
import com.davenonymous.pipegoggles.render.OverlayLineRenderType;
import com.davenonymous.pipegoggles.setup.ModDataComponents;
import com.davenonymous.pipegoggles.setup.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BoxRenderer {
    private static void renderLine(PoseStack.Pose pose, VertexConsumer consumer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha, float red2, float green2, float blue2) {
        float f = (float)minX;
        float f1 = (float)minY;
        float f2 = (float)minZ;
        float f3 = (float)maxX;
        float f4 = (float)maxY;
        float f5 = (float)maxZ;
        consumer.addVertex(pose, f, f1, f2).setColor(red2, green2, blue, alpha).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, f, f1, f5).setColor(red2, green2, blue, alpha).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, f3, f1, f2).setColor(red, green, blue, alpha).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, f3, f4, f2).setColor(red, green, blue, alpha).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, f3, f4, f2).setColor(red, green, blue, alpha).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, f, f4, f2).setColor(red, green, blue, alpha).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, f, f4, f2).setColor(red, green, blue, alpha).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, f, f4, f5).setColor(red, green, blue, alpha).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    private static void renderAllColors(Player player, ItemStack goggleStack, PoseStack poseStack) {
        PipeGoggleDataComponent data = (PipeGoggleDataComponent)goggleStack.getOrDefault(ModDataComponents.PIPEGOGGLES_COMPONENT, (Object)new PipeGoggleDataComponent());
        BoxOptimizer.updateBoxLineCaches(player, data);
        for (DyeColor color : data.colors().keySet()) {
            if (!data.isColorEnabled(color)) continue;
            if (!data.colors().containsKey(color) || data.colors().get(color).isEmpty()) {
                return;
            }
            BoxRenderer.renderVBO(poseStack, color, data.lineWidth());
        }
    }

    public static void onRenderLast(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Optional<ItemStack> optGoggleStack = PipeGoggleItem.getGoggleStack((Player)player);
        if (optGoggleStack.isEmpty()) {
            return;
        }
        ItemStack goggleStack = optGoggleStack.get();
        PipeGoggleDataComponent goggleData = PipeGoggleItem.data(goggleStack);
        if (goggleData.isDisabled()) {
            return;
        }
        if (!goggleData.enoughEnergy()) {
            return;
        }
        BoxOptimizer.updateBoxLineCaches((Player)player, goggleData);
        ItemStack heldItem = player.getMainHandItem();
        if (goggleData.goggleMode() == EnumGoggleMode.ON || heldItem.is((Item)ModItems.PIPE_GOGGLE_ITEM.get()) || player.getOffhandItem().is((Item)ModItems.PIPE_GOGGLE_ITEM.get())) {
            BoxRenderer.renderAllColors((Player)player, goggleStack, event.getPoseStack());
            return;
        }
        if (Client.autoModeRequiresCrouching && !player.isShiftKeyDown()) {
            return;
        }
        if (heldItem.isEmpty()) {
            heldItem = player.getOffhandItem();
        }
        if (heldItem.isEmpty()) {
            return;
        }
        Optional<DyeColor> optColor = goggleData.getColorForStack(heldItem);
        if (optColor.isEmpty()) {
            return;
        }
        if (!goggleData.isColorEnabled(optColor.get())) {
            return;
        }
        BoxRenderer.renderVBO(event.getPoseStack(), optColor.get(), goggleData.lineWidth());
    }

    public static void renderVBO(PoseStack poseStack, DyeColor color, int lineWidth) {
        BoxLineCache optimizer = BoxOptimizer.getBoxLineCache(color);
        VertexBuffer vertexBuffer = optimizer.vbo;
        if (vertexBuffer != null && !vertexBuffer.isInvalid()) {
            vertexBuffer.bind();
            Vec3 projection = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            double xOffset = -projection.x;
            double yOffset = -projection.y;
            double zOffset = -projection.z;
            poseStack.pushPose();
            poseStack.translate(xOffset, yOffset, zOffset);
            Matrix4f modelMatrix = poseStack.last().pose();
            OverlayLineRenderType.forThickness(lineWidth).setupRenderState();
            Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            viewMatrix.mul((Matrix4fc)modelMatrix);
            ShaderInstance shader = RenderSystem.getShader();
            shader.setDefaultUniforms(VertexFormat.Mode.LINES, viewMatrix, RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
            RenderSystem.setupShaderLights((ShaderInstance)shader);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            vertexBuffer.drawWithShader(viewMatrix, projectionMatrix, shader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexBuffer.unbind();
            poseStack.popPose();
        }
    }

    public static void createVBO(BufferBuilder bufferBuilder, Set<BoxLineCache.Line> lines, int color) {
        PoseStack.Pose pose = new PoseStack().last();
        for (BoxLineCache.Line line : lines) {
            double sx = line.start().x();
            double sy = line.start().y();
            double sz = line.start().z();
            double dx = line.end().x();
            double dy = line.end().y();
            double dz = line.end().z();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            BoxRenderer.renderLine(pose, (VertexConsumer)bufferBuilder, sx, sy, sz, dx, dy, dz, r, g, b, a, r, g, b);
        }
    }
}

