/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class OverlayLineRenderType
extends RenderType {
    private static final RenderStateShard.LineStateShard LIGHT_LINES = new RenderStateShard.LineStateShard(OptionalDouble.of(1.0));
    private static final RenderStateShard.LineStateShard NORMAL_LINES = new RenderStateShard.LineStateShard(OptionalDouble.of(2.0));
    private static final RenderStateShard.LineStateShard THICK_LINES = new RenderStateShard.LineStateShard(OptionalDouble.of(3.0));
    public static final RenderType OVERLAY_LINES_LIGHT = OverlayLineRenderType.createRenderType(1, LIGHT_LINES);
    public static final RenderType OVERLAY_LINES_NORMAL = OverlayLineRenderType.createRenderType(2, NORMAL_LINES);
    public static final RenderType OVERLAY_LINES_THICK = OverlayLineRenderType.createRenderType(3, THICK_LINES);

    public OverlayLineRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
        super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
    }

    private static RenderType.CompositeState createComposite(RenderStateShard.LineStateShard lineState) {
        return RenderType.CompositeState.builder().setLineState(lineState).setLayeringState(NO_LAYERING).setShaderState(RENDERTYPE_LINES_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setDepthTestState(NO_DEPTH_TEST).setOverlayState(NO_OVERLAY).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false);
    }

    private static RenderType createRenderType(int thickness, RenderStateShard.LineStateShard lineStateShard) {
        return OverlayLineRenderType.create((String)("overlay_lines_" + thickness + "_pipegoggles"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)OverlayLineRenderType.createComposite(lineStateShard));
    }

    public static RenderType forThickness(int thickness) {
        return switch (thickness) {
            case 1 -> OVERLAY_LINES_LIGHT;
            case 2 -> OVERLAY_LINES_NORMAL;
            case 3 -> OVERLAY_LINES_THICK;
            default -> OVERLAY_LINES_NORMAL;
        };
    }
}

