/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.render;

import com.davenonymous.pipegoggles.lib.gui.GUIHelper;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetWithRangeValue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public class WidgetTank
extends WidgetWithRangeValue<Long> {
    int borderColor = -16777216;
    int backgroundColor = -13421773;
    int centerColor = Blocks.WATER.defaultMapColor().calculateRGBColor(MapColor.Brightness.NORMAL);
    int outerColor = Blocks.WATER.defaultMapColor().calculateRGBColor(MapColor.Brightness.LOWEST);

    public WidgetTank(Long size) {
        this.setRange(0L, size);
        this.setValue(0L);
        this.setWidth(22);
    }

    public WidgetTank setCenterColor(int centerColor) {
        this.centerColor = centerColor;
        return this;
    }

    public WidgetTank setOuterColor(int outerColor) {
        this.outerColor = outerColor;
        return this;
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        double fillLevel = (double)((Long)this.getValue() - (Long)this.getRangeMin()) / (double)((Long)this.getRangeMax() - (Long)this.getRangeMin());
        fillLevel = Math.min(Math.max(fillLevel, 0.0), 1.0);
        int fillHeight = Math.max((int)(Math.ceil((double)this.height - 1.0) * (1.0 - fillLevel)), 1);
        int centerPoint = (int)Math.ceil((double)(this.width - 1) / 2.0);
        pGuiGraphics.fill(0, 0, this.width, this.height, this.borderColor);
        pGuiGraphics.fill(1, 1, this.width - 1, this.height - 1, this.backgroundColor);
        GUIHelper.fillHorizontalGradient(pGuiGraphics, 1, fillHeight, centerPoint, this.height - 1, this.outerColor, this.centerColor);
        GUIHelper.fillHorizontalGradient(pGuiGraphics, centerPoint, fillHeight, this.width - 1, this.height - 1, this.centerColor, this.outerColor);
    }
}

