/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.function.Supplier;
import net.creeperhost.polylib.blocks.ChangeListener;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.InteractableBlock;
import net.creeperhost.polylib.blocks.PolyBlock;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneEmitter;
import net.creeperhost.polylib.init.DataComps;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PolyEntityBlock
extends PolyBlock
implements EntityBlock {
    private Supplier<BlockEntityType<? extends PolyBlockEntity>> blockEntityType = null;
    private boolean enableTicking;

    public PolyEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public PolyEntityBlock setBlockEntity(Supplier<BlockEntityType<? extends PolyBlockEntity>> blockEntityType, boolean enableTicking) {
        this.blockEntityType = blockEntityType;
        this.enableTicking = enableTicking;
        return this;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntityType.get().create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (this.enableTicking && this.blockEntityType.get() == entityType) {
            return (e, e2, e3, tile) -> ((PolyBlockEntity)tile).tick();
        }
        return null;
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)blockEntity;
            return emitter.getWeakPower(state, side);
        }
        return super.getSignal(state, blockAccess, pos, side);
    }

    public int getDirectSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)blockEntity;
            return emitter.getStrongPower(state, side);
        }
        return super.getDirectSignal(state, blockAccess, pos, side);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChangeListener) {
            ChangeListener listener = (ChangeListener)blockEntity;
            listener.onNeighborChange(blockIn, fromPos, isMoving);
        }
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)blockEntity;
            return interactable.onBlockUse(blockState, level, pos, player, blockHitResult);
        }
        return super.useWithoutItem(blockState, level, pos, player, blockHitResult);
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)blockEntity;
            interactable.onBlockAttack(player);
        }
        super.attack(state, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DataRetainingBlock) {
            DataRetainingBlock retaining = (DataRetainingBlock)blockEntity;
            if (stack.has(DataComps.getItemTileData())) {
                retaining.readFromItemStack((HolderLookup.Provider)level.registryAccess(), ((CustomData)stack.get(DataComps.getItemTileData())).copyTag());
            }
        }
        if (blockEntity instanceof PolyBlockEntity) {
            PolyBlockEntity polyBlock = (PolyBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                polyBlock.setCustomName(stack.getHoverName());
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        DataRetainingBlock retaining;
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem() && (level instanceof ServerLevel || !this.isCTRLKeyDown())) {
            CompoundTag nbt = new CompoundTag();
            ((DataRetainingBlock)blockEntity).writeToItemStack((HolderLookup.Provider)level.registryAccess(), nbt, false);
            if (!nbt.isEmpty()) {
                stack.set(DataComps.getItemTileData(), (Object)CustomData.of((CompoundTag)nbt));
            }
        }
        if (blockEntity instanceof Nameable) {
            Nameable nameable = (Nameable)blockEntity;
            if (((Nameable)blockEntity).hasCustomName()) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)nameable.getName());
            }
        }
        return stack;
    }

    private boolean isCTRLKeyDown() {
        return Screen.hasControlDown();
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack heldStack) {
        Nameable nameable;
        DataRetainingBlock retaining;
        ItemStack stack = ItemStack.EMPTY;
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem()) {
            CompoundTag nbt = new CompoundTag();
            retaining.writeToItemStack((HolderLookup.Provider)level.registryAccess(), nbt, true);
            if (!nbt.isEmpty()) {
                stack = new ItemStack((ItemLike)this, 1);
                stack.set(DataComps.getItemTileData(), (Object)CustomData.of((CompoundTag)nbt));
            }
        }
        if (blockEntity instanceof Nameable && (nameable = (Nameable)blockEntity).hasCustomName()) {
            if (stack.isEmpty()) {
                stack = new ItemStack((ItemLike)this, 1);
            }
            stack.set(DataComponents.CUSTOM_NAME, (Object)nameable.getName());
        }
        if (!stack.isEmpty()) {
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
            PolyEntityBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            level.removeBlockEntity(pos);
        } else {
            super.playerDestroy(level, player, pos, state, blockEntity, heldStack);
        }
    }
}

