/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.neoforge.inventory.fluid;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class NeoPolyFluidWrapper
implements PolyFluidHandler {
    private final IFluidHandler handler;

    public NeoPolyFluidWrapper(IFluidHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getTanks() {
        return this.handler.getTanks();
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)this.handler.getFluidInTank(tank));
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
        return this.handler.isFluidValid(tank, FluidStackHooksForge.toForge((FluidStack)fluidStack));
    }

    @Override
    public long fill(FluidStack fluidStack, boolean simulate) {
        return this.handler.fill(FluidStackHooksForge.toForge((FluidStack)fluidStack), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack fluidStack, boolean simulate) {
        return FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)this.handler.drain(FluidStackHooksForge.toForge((FluidStack)fluidStack), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    public void _setFluidInTank(int tank, FluidStack fluidStack) {
    }

    @Override
    @NotNull
    public FluidStack drain(long amount, boolean simulate) {
        return FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)this.handler.drain((int)Math.max(amount, Integer.MAX_VALUE), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }
}

