/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.productivemetalworks.ProductiveMetalworks;
import cy.jdkdigital.productivemetalworks.common.block.HotLiquidBlock;
import cy.jdkdigital.productivemetalworks.common.block.MeatBlock;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            ProductiveMetalworks.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        MetalworksRegistrator.FOUNDRY_CONTROLLERS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "_off", itemModels));
        MetalworksRegistrator.FOUNDRY_DRAINS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        MetalworksRegistrator.FOUNDRY_TANKS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        MetalworksRegistrator.FOUNDRY_CAPACITORS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        MetalworksRegistrator.FOUNDRY_WINDOWS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        MetalworksRegistrator.FIRE_BRICKS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        this.addBlockItemModel((Block)MetalworksRegistrator.FOUNDRY_TAP.get(), "foundry_tap_base", itemModels);
        this.addBlockItemParentModel((Block)MetalworksRegistrator.FIRE_CLAY.get(), "", "", itemModels);
        this.addBlockItemParentModel((Block)MetalworksRegistrator.LIQUID_HEATING_COIL.get(), "", "_off", itemModels);
        this.addBlockItemParentModel((Block)MetalworksRegistrator.POWERED_HEATING_COIL.get(), "", "_off", itemModels);
        this.addBlockItemParentModel((Block)MetalworksRegistrator.HIGH_POWERED_HEATING_COIL.get(), "", "_off", itemModels);
        this.addBlockItemModel((Block)MetalworksRegistrator.CASTING_BASIN.get(), "casting_basin_base", itemModels);
        this.addBlockItemModel((Block)MetalworksRegistrator.CASTING_TABLE.get(), "casting_table_base", itemModels);
        this.addBlockItemParentModel((Block)MetalworksRegistrator.MEAT_BLOCK.get(), "", "", itemModels);
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), BlockModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return BlockModelProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        return BlockModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item), prefix, suffix);
    }

    private static TextureMapping getFlatItemTextureMap(ResourceLocation resourceLocation, String prefix, String suffix) {
        return new TextureMapping().put(TextureSlot.LAYER0, resourceLocation.withPrefix(prefix).withSuffix(suffix));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemModel(Block block, String base, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("block/" + base))), itemModels);
        }
    }

    private void addBlockItemParentModel(Block block, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.addItemParentModel(item, rl, "block/" + prefix, suffix, itemModels);
        }
    }

    private void addItemParentModel(Item item, ResourceLocation rl, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(prefix + rl.getPath() + suffix))), itemModels);
    }

    public String getName() {
        return "Productive Metalworks Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
        static ModelTemplate controllerBaseModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_controller_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP});
        static ModelTemplate drainBaseModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_drain_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP});
        static ModelTemplate tankBaseModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_tank_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP});
        static ModelTemplate capacitorBaseModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_capacitor_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP});
        static ModelTemplate windowBaseModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_window_base")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.SIDE, TextureSlot.TOP});

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            MetalworksRegistrator.FOUNDRY_CONTROLLERS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createBasedBlockOnOff((Block)holder.get(), controllerBaseModel, (DyeColor)dyeColor, "block/foundry_controller_front_on", "block/foundry_controller_front_off")));
            MetalworksRegistrator.FOUNDRY_DRAINS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createBasedBlock((Block)holder.get(), drainBaseModel, (DyeColor)dyeColor, "block/foundry_drain_front")));
            MetalworksRegistrator.FOUNDRY_TANKS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createBasedBlock((Block)holder.get(), tankBaseModel, (DyeColor)dyeColor, "block/" + dyeColor.getSerializedName() + "_foundry_tank_front")));
            MetalworksRegistrator.FOUNDRY_CAPACITORS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createBasedBlock((Block)holder.get(), capacitorBaseModel, (DyeColor)dyeColor, "block/" + dyeColor.getSerializedName() + "_foundry_capacitor_front")));
            MetalworksRegistrator.FOUNDRY_WINDOWS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createBasedBlock((Block)holder.get(), windowBaseModel, (DyeColor)dyeColor, "block/" + dyeColor.getSerializedName() + "_foundry_window_front")));
            MetalworksRegistrator.FIRE_BRICKS.forEach((dyeColor, holder) -> this.blockStateOutput.accept((BlockStateGenerator)this.createHorizontalFacingFullBlock((Block)holder.get())));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHorizontalFacing((Block)MetalworksRegistrator.FOUNDRY_TAP.get(), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/foundry_tap_base")));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHeatingCoil((Block)MetalworksRegistrator.LIQUID_HEATING_COIL.get()));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHeatingCoil((Block)MetalworksRegistrator.POWERED_HEATING_COIL.get()));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHeatingCoil((Block)MetalworksRegistrator.HIGH_POWERED_HEATING_COIL.get()));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHorizontalFacing((Block)MetalworksRegistrator.CASTING_BASIN.get(), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/casting_basin_base")));
            this.blockStateOutput.accept((BlockStateGenerator)this.createHorizontalFacing((Block)MetalworksRegistrator.CASTING_TABLE.get(), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/casting_table_base")));
            this.blockStateOutput.accept((BlockStateGenerator)this.createFullBlock((Block)MetalworksRegistrator.FIRE_CLAY.get()));
            this.blockStateOutput.accept((BlockStateGenerator)this.createSlicedPillarBlock((Block)MetalworksRegistrator.MEAT_BLOCK.get()));
            ProductiveMetalworks.BLOCKS.getEntries().stream().filter(h -> h.get() instanceof HotLiquidBlock).forEach(block -> this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock((Block)block.get(), ModelTemplates.CUBE_ALL.create((Block)block.get(), TextureMapping.cube((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"block/fluid/molten_metal")), this.modelOutput))));
        }

        MultiVariantGenerator createBasedBlock(Block block, ModelTemplate baseTemplate, DyeColor color, String frontTexture) {
            TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.FRONT, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)frontTexture));
            ResourceLocation model = baseTemplate.create(block, mapping, this.modelOutput);
            return this.createHorizontalFacing(block, model);
        }

        MultiVariantGenerator createBasedBlockOnOff(Block block, ModelTemplate baseTemplate, DyeColor color, String frontTextureOn, String frontTextureOff) {
            TextureMapping mappingOn = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.FRONT, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)frontTextureOn));
            TextureMapping mappingOff = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)MetalworksRegistrator.FIRE_BRICKS.get(color).get()))).put(TextureSlot.FRONT, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)frontTextureOff));
            ResourceLocation modelOn = baseTemplate.createWithSuffix(block, "_on", mappingOn, this.modelOutput);
            ResourceLocation modelOff = baseTemplate.createWithSuffix(block, "_off", mappingOff, this.modelOutput);
            return this.createHorizontalFacingOnOff(block, modelOn, modelOff);
        }

        MultiVariantGenerator createHorizontalFacingFullBlock(Block block) {
            ResourceLocation model = ModelTemplates.CUBE_ORIENTABLE.create(block, TextureMapping.cube((Block)block), this.modelOutput);
            return this.createHorizontalFacing(block, model);
        }

        MultiVariantGenerator createHorizontalFacing(Block block, ResourceLocation modelLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation)).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.MODEL, (Object)modelLocation)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant()));
        }

        MultiVariantGenerator createHorizontalFacingOnOff(Block block, ResourceLocation onModel, ResourceLocation offModel) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant()).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant())).with(PropertyDispatch.property((Property)BlockStateProperties.ATTACHED).generate(on -> Variant.variant().with(VariantProperties.MODEL, (Object)(on != false ? onModel : offModel))));
        }

        MultiVariantGenerator createHeatingCoil(Block block) {
            TextureMapping mappingOn = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)block, (String)"_top_on")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side_on")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top_on"));
            TextureMapping mappingOff = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)block, (String)"_top_off")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side_off")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top_off"));
            ResourceLocation onModel = ModelTemplates.CUBE_BOTTOM_TOP.createWithSuffix(block, "_on", mappingOn, this.modelOutput);
            ResourceLocation offModel = ModelTemplates.CUBE_BOTTOM_TOP.createWithSuffix(block, "_off", mappingOff, this.modelOutput);
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant()).with(PropertyDispatch.property((Property)BlockStateProperties.ATTACHED).generate(on -> Variant.variant().with(VariantProperties.MODEL, (Object)(on != false ? onModel : offModel))));
        }

        MultiVariantGenerator createAxisAlignedPillarBlock(Block axisAlignedPillarBlock, TexturedModel.Provider provider) {
            ResourceLocation resourcelocation = provider.create(axisAlignedPillarBlock, this.modelOutput);
            return MultiVariantGenerator.multiVariant((Block)axisAlignedPillarBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation)).with(this.createRotatedPillar());
        }

        MultiVariantGenerator createFullBlock(Block block) {
            TextureMapping mapping = new TextureMapping().put(TextureSlot.ALL, TextureMapping.getBlockTexture((Block)block));
            ResourceLocation model = ModelTemplates.CUBE_ALL.create(block, mapping, this.modelOutput);
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model));
        }

        MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation modelLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation));
        }

        PropertyDispatch createRotatedPillar() {
            return PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.Y, Variant.variant()).select((Comparable)Direction.Axis.Z, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.Axis.X, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
        }

        private MultiVariantGenerator createSlicedPillarBlock(Block block) {
            return MultiVariantGenerator.multiVariant((Block)block).with(this.createRotatedPillar()).with((PropertyDispatch)PropertyDispatch.property((Property)MeatBlock.BITES).select((Comparable)Integer.valueOf(0), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block))).select((Comparable)Integer.valueOf(1), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_1"))).select((Comparable)Integer.valueOf(2), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_2"))).select((Comparable)Integer.valueOf(3), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_3"))).select((Comparable)Integer.valueOf(4), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_4"))).select((Comparable)Integer.valueOf(5), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_5"))).select((Comparable)Integer.valueOf(6), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_6"))).select((Comparable)Integer.valueOf(7), Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block, (String)"_7"))));
        }
    }
}

