/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.datagen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivemetalworks.common.block.MeatBlock;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Productive Foundry Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            MetalworksRegistrator.FOUNDRY_CONTROLLERS.forEach((dyeColor, holder) -> this.dropSelf((Block)holder.get()));
            MetalworksRegistrator.FOUNDRY_DRAINS.forEach((dyeColor, holder) -> this.dropSelf((Block)holder.get()));
            MetalworksRegistrator.FOUNDRY_TANKS.forEach((dyeColor, holder) -> this.dropFluidContainer((Block)holder.get()));
            MetalworksRegistrator.FOUNDRY_CAPACITORS.forEach((dyeColor, holder) -> this.dropSelf((Block)holder.get()));
            MetalworksRegistrator.FOUNDRY_WINDOWS.forEach((dyeColor, holder) -> this.dropSelf((Block)holder.get()));
            MetalworksRegistrator.FIRE_BRICKS.forEach((dyeColor, holder) -> this.dropSelf((Block)holder.get()));
            this.dropSelf((Block)MetalworksRegistrator.FOUNDRY_TAP.get());
            this.dropSelf((Block)MetalworksRegistrator.CASTING_BASIN.get());
            this.dropSelf((Block)MetalworksRegistrator.CASTING_TABLE.get());
            this.dropSelf((Block)MetalworksRegistrator.LIQUID_HEATING_COIL.get());
            this.dropSelf((Block)MetalworksRegistrator.POWERED_HEATING_COIL.get());
            this.dropSelf((Block)MetalworksRegistrator.HIGH_POWERED_HEATING_COIL.get());
            this.createSelfDropDispatchTable((Block)MetalworksRegistrator.MEAT_BLOCK.get(), (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)MetalworksRegistrator.MEAT_BLOCK.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MeatBlock.BITES, 0)));
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        public void dropSelf(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.add(block, func.apply(block));
        }

        public void dropFluidContainer(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genFluidTankBlockDrop);
            this.add(block, func.apply(block));
        }

        protected void createSelfDropDispatchTable(Block block, LootItemCondition.Builder conditions) {
            this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when(conditions))));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }

        protected static LootTable.Builder genFluidTankBlockDrop(Block block) {
            LootPoolSingletonContainer.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(MetalworksRegistrator.FLUID_STACK.get()));
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)builder));
        }
    }
}

