/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivemetalworks.recipe.ItemCastingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class BlockCastingRecipe
extends ItemCastingRecipe {
    public BlockCastingRecipe(Ingredient cast, SizedFluidIngredient fluid, ItemStack result, boolean consumeCast) {
        super(cast, fluid, result, consumeCast);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MetalworksRegistrator.BLOCK_CASTING.get();
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)MetalworksRegistrator.BLOCK_CASTING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BlockCastingRecipe> {
        private static final MapCodec<BlockCastingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("cast").orElse((Object)Ingredient.EMPTY).forGetter(recipe -> recipe.cast), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(recipe -> recipe.fluid), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.fieldOf("consume_cast").orElse((Object)false).forGetter(recipe -> recipe.consumeCast)).apply((Applicative)builder, BlockCastingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockCastingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BlockCastingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockCastingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BlockCastingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new BlockCastingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (SizedFluidIngredient)SizedFluidIngredient.STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readBoolean());
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, BlockCastingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.cast);
            SizedFluidIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.consumeCast);
        }
    }
}

