/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FluidAlloyingRecipe
implements Recipe<RecipeInput> {
    public final List<SizedFluidIngredient> fluids;
    public final int speed;
    public final FluidStack result;

    public FluidAlloyingRecipe(List<SizedFluidIngredient> fluids, int speed, FluidStack result) {
        this.fluids = fluids;
        this.speed = speed;
        this.result = result;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public boolean matches(List<FluidStack> availableFluids) {
        return this.fluids.stream().allMatch(sizedFluidIngredient -> {
            boolean hasMatch = false;
            for (FluidStack fluidStack : availableFluids) {
                if (!sizedFluidIngredient.test(fluidStack)) continue;
                hasMatch = true;
                break;
            }
            return hasMatch;
        });
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MetalworksRegistrator.FLUID_ALLOYING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MetalworksRegistrator.FLUID_ALLOYING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidAlloyingRecipe> {
        private static final MapCodec<FluidAlloyingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedFluidIngredient.FLAT_CODEC.listOf().fieldOf("fluids").forGetter(recipe -> recipe.fluids), (App)Codec.INT.fieldOf("speed").orElse((Object)1).forGetter(recipe -> recipe.speed), (App)FluidStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, FluidAlloyingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidAlloyingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FluidAlloyingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidAlloyingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static FluidAlloyingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new FluidAlloyingRecipe((List)SizedFluidIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer), buffer.readInt(), (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, FluidAlloyingRecipe recipe) {
            SizedFluidIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.fluids);
            buffer.writeInt(recipe.speed);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

