/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen;

import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockModelProviderImpl
extends BlockModelProvider {
    private static final String BLOCK_PREFIX = "block";

    public BlockModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedtypes", existingFileHelper);
    }

    protected void registerModels() {
        this.registerEnergyStorageBlock();
        this.registerSourceStorageBlock();
        this.registerSoulStorageBlock();
    }

    private void registerEnergyStorageBlock() {
        for (EnergyStorageVariant variant : EnergyStorageVariant.values()) {
            String name = variant.getName() + "_energy_storage_block";
            this.cubeAll(name, RefinedTypesUtil.createRefinedTypesIdentifier("block/energy_storage_block/" + name));
        }
    }

    private void registerSourceStorageBlock() {
        for (SourceStorageVariant variant : SourceStorageVariant.values()) {
            String name = variant.getName() + "_source_storage_block";
            this.cubeAll(name, RefinedTypesUtil.createRefinedTypesIdentifier("block/source_storage_block/" + name));
        }
    }

    private void registerSoulStorageBlock() {
        for (SoulStorageVariant variant : SoulStorageVariant.values()) {
            String name = variant.getName() + "_soul_storage_block";
            this.cubeAll(name, RefinedTypesUtil.createRefinedTypesIdentifier("block/soul_storage_block/" + name));
        }
    }
}

