/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen;

import com.ultramega.refinedtypes.datagen.AdvancementProviderImpl;
import com.ultramega.refinedtypes.datagen.BlockModelProviderImpl;
import com.ultramega.refinedtypes.datagen.BlockStateProviderImpl;
import com.ultramega.refinedtypes.datagen.ItemModelProviderImpl;
import com.ultramega.refinedtypes.datagen.loot.BlockLootTableProviderImpl;
import com.ultramega.refinedtypes.datagen.recipe.RecipeProviderImpl;
import com.ultramega.refinedtypes.datagen.tag.BlockTagsProviderImpl;
import com.ultramega.refinedtypes.datagen.tag.ItemTagsProviderImpl;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="refinedtypes")
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent e) {
        DataGenerators.registerBlockModelProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerItemModelProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerBlockStateProviders(e.getGenerator(), e.getExistingFileHelper());
        DataGenerators.registerLootTableProviders(e.getGenerator(), e.getLookupProvider());
        DataGenerators.registerRecipeProviders(e.getGenerator(), e.getLookupProvider());
        DataGenerators.registerTagProviders(e.getGenerator(), e.getLookupProvider(), e.getExistingFileHelper());
        DataGenerators.registerAdvancementProviders(e.getGenerator(), e.getLookupProvider(), e.getExistingFileHelper());
    }

    private static void registerBlockModelProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new BlockModelProviderImpl(output, existingFileHelper));
    }

    private static void registerBlockStateProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new BlockStateProviderImpl(output, existingFileHelper));
    }

    private static void registerItemModelProviders(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new ItemModelProviderImpl(output, existingFileHelper));
    }

    private static void registerLootTableProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new BlockLootTableProviderImpl(output, provider));
    }

    private static void registerRecipeProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new RecipeProviderImpl(output, provider));
    }

    private static void registerTagProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        BlockTagsProviderImpl blockTagsProvider = (BlockTagsProviderImpl)mainPack.addProvider(output -> new BlockTagsProviderImpl(output, provider, existingFileHelper));
        mainPack.addProvider(output -> new ItemTagsProviderImpl(output, provider, blockTagsProvider, existingFileHelper));
    }

    private static void registerAdvancementProviders(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        DataGenerator.PackGenerator mainPack = generator.getVanillaPack(true);
        mainPack.addProvider(output -> new AdvancementProviderImpl(output, provider, existingFileHelper));
    }
}

