/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.source;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class SourceCapabilityCache {
    private final BlockCapabilityCache<ISourceCap, @NullableType Direction> cache;

    public SourceCapabilityCache(ServerLevel level, BlockPos pos, Direction direction) {
        this.cache = BlockCapabilityCache.create((BlockCapability)CapabilityRegistry.SOURCE_CAPABILITY, (ServerLevel)level, (BlockPos)pos, (Object)direction);
    }

    public Optional<ISourceCap> getCapability() {
        return Optional.ofNullable((ISourceCap)this.cache.getCapability());
    }

    public Iterator<ResourceAmount> createAmountIterator() {
        return this.getCapability().map(handler -> {
            long amount = handler.getSource();
            if (amount > 0L) {
                return Collections.singletonList(new ResourceAmount((ResourceKey)SourceResource.createSourceResource(), amount)).iterator();
            }
            return Collections.emptyIterator();
        }).orElse(Collections.emptyListIterator());
    }

    public Iterator<ResourceKey> createIterator() {
        return this.getCapability().map(handler -> {
            long amount = handler.getSource();
            if (amount > 0L) {
                return Collections.singletonList(SourceResource.createSourceResource()).iterator();
            }
            return Collections.emptyListIterator();
        }).orElse(Collections.emptyListIterator());
    }
}

