/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.recipemod;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Optional;
import mekanism.api.IMekanismAccess;
import mekanism.api.chemical.Chemical;

public class EmiChemicalResourceModIngredientConverter
implements RecipeModIngredientConverter {
    public Optional<PlatformResourceKey> convertToResource(Object ingredient) {
        if (ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            return IMekanismAccess.INSTANCE.emiHelper().asChemicalStack(emiStack).map(ChemicalResource::ofChemicalStack);
        }
        return Optional.empty();
    }

    public Optional<ResourceAmount> convertToResourceAmount(Object ingredient) {
        if (ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            return IMekanismAccess.INSTANCE.emiHelper().asChemicalStack(emiStack).map(chemical -> new ResourceAmount((ResourceKey)ChemicalResource.ofChemicalStack(chemical), emiStack.getAmount()));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Object> convertToIngredient(PlatformResourceKey resourceKey) {
        Chemical chemical2;
        if (!(resourceKey instanceof ChemicalResource)) return Optional.empty();
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical;
            chemical2 = chemical = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Optional.of(IMekanismAccess.INSTANCE.emiHelper().createEmiStack(chemical2, 1000L));
    }
}

