/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.core;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.0")
public final class CoreValidations {
    private CoreValidations() {
    }

    public static <T> void validateEquals(@Nullable T a, @Nullable T b, String message) {
        if (!Objects.equals(a, b)) {
            throw new IllegalStateException(message);
        }
    }

    public static <T> T validateNotNull(@Nullable T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    public static <T> void validateNull(@Nullable T value, String message) {
        if (value != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNegative(long value, String message) {
        if (value >= 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    public static int validateNotNegative(int value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static long validateNotNegative(long value, String message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static void validateLargerThanZero(long value, String message) {
        if (value <= 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void validateEmpty(Collection<T> collection, String message) {
        if (!collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void validateNotEmpty(Collection<T> collection, String message) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void validateContains(Collection<T> collection, T value, String message) {
        if (!collection.contains(value)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void validateNotContains(Collection<T> collection, T value, String message) {
        if (collection.contains(value)) {
            throw new IllegalArgumentException(message);
        }
    }
}

