/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.controller;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.controller.ControllerEnergyState;
import javax.annotation.Nullable;

public class ControllerNetworkNode
extends AbstractNetworkNode
implements EnergyProvider {
    @Nullable
    private EnergyStorage energyStorage;

    public void setEnergyStorage(@Nullable EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public ControllerEnergyState getState() {
        if (!this.isActive() || this.energyStorage == null) {
            return ControllerEnergyState.OFF;
        }
        double pct = (double)this.energyStorage.getStored() / (double)this.energyStorage.getCapacity();
        return this.getState(pct);
    }

    private ControllerEnergyState getState(double pct) {
        if (pct >= 0.4) {
            return ControllerEnergyState.ON;
        }
        if (pct >= 0.3) {
            return ControllerEnergyState.NEARLY_ON;
        }
        if (pct >= 0.01) {
            return ControllerEnergyState.NEARLY_OFF;
        }
        return ControllerEnergyState.OFF;
    }

    @Override
    public long getStored() {
        if (!this.isActive()) {
            return 0L;
        }
        return this.getActualStored();
    }

    public long getActualStored() {
        return this.energyStorage == null ? 0L : this.energyStorage.getStored();
    }

    @Override
    public long getCapacity() {
        if (!this.isActive()) {
            return 0L;
        }
        return this.getActualCapacity();
    }

    public long getActualCapacity() {
        return this.energyStorage == null ? 0L : this.energyStorage.getCapacity();
    }

    @Override
    public long extract(long amount) {
        if (this.energyStorage == null) {
            return 0L;
        }
        return this.energyStorage.extract(amount, Action.EXECUTE);
    }

    @Override
    public long getEnergyUsage() {
        return 0L;
    }
}

