/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.repository;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.CachingResourceRepositoryMapper;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.api.resource.repository.SortingDirection;
import com.refinedmods.refinedstorage.api.resource.repository.ViewList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public class ResourceRepositoryImpl<T>
implements ResourceRepository<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRepositoryImpl.class);
    private final MutableResourceList backingList;
    private final Comparator<T> identitySort;
    private final ResourceRepositoryMapper<T> mapper;
    private final Set<ResourceKey> stickyResources;
    private ViewList<T> viewList = new ViewList();
    private Comparator<T> sort;
    private ResourceRepositoryFilter<T> filter = (view, resource) -> true;
    @Nullable
    private Runnable listener;
    private boolean preventSorting;

    public ResourceRepositoryImpl(ResourceRepositoryMapper<T> mapper, MutableResourceList backingList, Set<ResourceKey> stickyResources, Function<ResourceRepository<T>, Comparator<T>> identitySortingType, Function<ResourceRepository<T>, Comparator<T>> defaultSortingType) {
        this.mapper = new CachingResourceRepositoryMapper<T>(mapper);
        this.identitySort = identitySortingType.apply(this);
        this.sort = ResourceRepositoryImpl.createSort(defaultSortingType.apply(this), this.identitySort, SortingDirection.ASCENDING);
        this.backingList = backingList;
        this.stickyResources = stickyResources;
    }

    @Override
    public void setListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void setSort(Comparator<T> theSort, SortingDirection direction) {
        this.sort = ResourceRepositoryImpl.createSort(theSort, this.identitySort, direction);
    }

    @Override
    public ResourceRepositoryFilter<T> setFilterAndSort(ResourceRepositoryFilter<T> theFilter) {
        ResourceRepositoryFilter<T> previousFilter = this.filter;
        this.filter = theFilter;
        this.sort();
        return previousFilter;
    }

    @Override
    public boolean setPreventSorting(boolean thePreventSorting) {
        boolean changed = this.preventSorting != thePreventSorting;
        this.preventSorting = thePreventSorting;
        return changed;
    }

    @Override
    public long getAmount(ResourceKey resource) {
        return this.backingList.get(resource);
    }

    @Override
    public boolean isSticky(ResourceKey resource) {
        return this.stickyResources.contains(resource);
    }

    @Override
    public void sort() {
        LOGGER.debug("Sorting resource repository");
        this.viewList = ViewList.createSorted(this.backingList, this.stickyResources, this.sort, this.mapper, resource -> this.filter.test(this, resource));
        this.notifyListener();
    }

    @Override
    public void update(ResourceKey resource, long amount) {
        if (amount == 0L) {
            throw new IllegalArgumentException("Amount must be non-zero");
        }
        MutableResourceList.OperationResult backingListResult = this.updateBackingList(resource, amount);
        if (backingListResult == null) {
            LOGGER.warn("Failed to update backing list for {} {}", (Object)amount, (Object)resource);
            return;
        }
        T mapped = this.viewList.get(resource);
        if (mapped != null) {
            this.updateExisting(resource, !backingListResult.available(), mapped);
            return;
        }
        this.tryAddNewResource(resource);
    }

    @Nullable
    private MutableResourceList.OperationResult updateBackingList(ResourceKey resource, long amount) {
        if (amount < 0L) {
            return this.backingList.remove(resource, Math.abs(amount));
        }
        return this.backingList.add(resource, amount);
    }

    private void updateExisting(ResourceKey resource, boolean removedFromBackingList, T mapped) {
        boolean canBeSorted;
        boolean bl = canBeSorted = !this.preventSorting;
        if (canBeSorted) {
            LOGGER.debug("Actually updating {} resource in the view list", (Object)resource);
            if (removedFromBackingList && !this.stickyResources.contains(resource)) {
                this.viewList.remove(resource, mapped);
                this.notifyListener();
            } else {
                this.viewList.update(mapped, this.sort);
                this.notifyListener();
            }
        } else if (removedFromBackingList) {
            LOGGER.debug("{} is no longer available", (Object)resource);
        } else {
            LOGGER.debug("{} can't be sorted, preventing sorting is on", (Object)resource);
        }
    }

    private void tryAddNewResource(ResourceKey resource) {
        Object mapped = this.mapper.apply(resource);
        if (this.filter.test(this, mapped)) {
            LOGGER.debug("Filter allowed, actually adding {}", (Object)resource);
            this.viewList.add(resource, mapped, this.sort);
            this.notifyListener();
        }
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public List<T> getViewList() {
        return this.viewList.getListView();
    }

    @Override
    public MutableResourceList copyBackingList() {
        return this.backingList.copy();
    }

    @Override
    public void clear() {
        this.backingList.clear();
        this.viewList.clear();
    }

    private static <T> Comparator<T> createSort(Comparator<T> sort, Comparator<T> identitySort, SortingDirection direction) {
        Comparator<T> comparator = sort.thenComparing(identitySort);
        if (direction == SortingDirection.ASCENDING) {
            return comparator;
        }
        return comparator.reversed();
    }
}

