/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.SmithingTablePatternState;
import com.refinedmods.refinedstorage.common.autocrafting.StonecutterPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridData;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternOutputContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternTypeSettings;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingInputData;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.StonecutterInputContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlockEntity;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.ResourceSorters;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PatternGridBlockEntity
extends AbstractGridBlockEntity
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<PatternGridData> {
    private static final String TAG_CRAFTING_INPUT = "crafting_input";
    private static final String TAG_PATTERN_INPUT = "pattern_input";
    private static final String TAG_PATTERN_OUTPUT = "pattern_output";
    private static final String TAG_PROCESSING_INPUT = "processing_input";
    private static final String TAG_PROCESSING_OUTPUT = "processing_output";
    private static final String TAG_FUZZY_MODE = "fuzzy_mode";
    private static final String TAG_PATTERN_TYPE = "processing";
    private static final String TAG_STONECUTTER_INPUT = "stonecutter_input";
    private static final String TAG_STONECUTTER_SELECTED_RECIPE = "stonecutter_selected_recipe";
    private static final String TAG_SMITHING_INPUT = "smithing_input";
    private final RecipeMatrix<CraftingRecipe, CraftingInput> craftingRecipe = RecipeMatrix.crafting(() -> ((PatternGridBlockEntity)this).setChanged(), () -> ((PatternGridBlockEntity)this).getLevel());
    private final ProcessingMatrixInputResourceContainer processingInput = PatternGridBlockEntity.createProcessingMatrixInputContainer();
    private final ResourceContainer processingOutput = PatternGridBlockEntity.createProcessingMatrixOutputContainer();
    private final FilteredContainer patternInput = new FilteredContainer(1, PatternGridBlockEntity::isValidPattern);
    private final FilteredContainer patternOutput = new PatternOutputContainer();
    private final StonecutterInputContainer stonecutterInput = new StonecutterInputContainer(() -> ((PatternGridBlockEntity)this).getLevel());
    private final RecipeMatrix<SmithingRecipe, SmithingRecipeInput> smithingTableRecipe = RecipeMatrix.smithingTable(() -> ((PatternGridBlockEntity)this).setChanged(), () -> ((PatternGridBlockEntity)this).getLevel());
    private boolean fuzzyMode;
    private PatternType patternType = PatternType.CRAFTING;

    public PatternGridBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getPatternGrid(), pos, state, Platform.INSTANCE.getConfig().getPatternGrid().getEnergyUsage());
        this.patternInput.addListener(container -> this.setChanged());
        this.patternOutput.addListener(container -> this.setChanged());
        this.processingInput.setListener(() -> ((PatternGridBlockEntity)this).setChanged());
        this.processingOutput.setListener(() -> ((PatternGridBlockEntity)this).setChanged());
        this.stonecutterInput.addListener(container -> this.setChanged());
    }

    RecipeMatrixContainer getCraftingMatrix() {
        return this.craftingRecipe.getMatrix();
    }

    ResultContainer getCraftingResult() {
        return this.craftingRecipe.getResult();
    }

    ProcessingMatrixInputResourceContainer getProcessingInput() {
        return this.processingInput;
    }

    ResourceContainer getProcessingOutput() {
        return this.processingOutput;
    }

    public FilteredContainer getPatternInput() {
        return this.patternInput;
    }

    FilteredContainer getPatternOutput() {
        return this.patternOutput;
    }

    StonecutterInputContainer getStonecutterInput() {
        return this.stonecutterInput;
    }

    int getStonecutterSelectedRecipe() {
        return this.stonecutterInput.getSelectedRecipe();
    }

    void setStonecutterSelectedRecipe(int index) {
        this.stonecutterInput.setSelectedRecipe(index);
        this.setChanged();
    }

    RecipeMatrixContainer getSmithingTableMatrix() {
        return this.smithingTableRecipe.getMatrix();
    }

    ResultContainer getSmithingTableResult() {
        return this.smithingTableRecipe.getResult();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_PATTERN_INPUT, (Tag)ContainerUtil.write((Container)this.patternInput, provider));
        tag.put(TAG_PATTERN_OUTPUT, (Tag)ContainerUtil.write((Container)this.patternOutput, provider));
        tag.putBoolean(TAG_FUZZY_MODE, this.fuzzyMode);
        tag.putInt(TAG_PATTERN_TYPE, PatternTypeSettings.getPatternType(this.patternType));
        tag.put(TAG_PROCESSING_INPUT, (Tag)this.processingInput.toTag(provider));
        tag.put(TAG_PROCESSING_OUTPUT, (Tag)this.processingOutput.toTag(provider));
        tag.put(TAG_STONECUTTER_INPUT, (Tag)ContainerUtil.write((Container)this.stonecutterInput, provider));
        tag.putInt(TAG_STONECUTTER_SELECTED_RECIPE, this.stonecutterInput.getSelectedRecipe());
        tag.put(TAG_SMITHING_INPUT, (Tag)this.smithingTableRecipe.writeToTag(provider));
        tag.put(TAG_CRAFTING_INPUT, (Tag)this.craftingRecipe.writeToTag(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_PATTERN_INPUT)) {
            ContainerUtil.read(tag.getCompound(TAG_PATTERN_INPUT), (Container)this.patternInput, provider);
        }
        if (tag.contains(TAG_PATTERN_OUTPUT)) {
            ContainerUtil.read(tag.getCompound(TAG_PATTERN_OUTPUT), (Container)this.patternOutput, provider);
        }
        this.fuzzyMode = tag.getBoolean(TAG_FUZZY_MODE);
        this.patternType = PatternTypeSettings.getPatternType(tag.getInt(TAG_PATTERN_TYPE));
        if (tag.contains(TAG_PROCESSING_INPUT)) {
            this.processingInput.fromTag(tag.getCompound(TAG_PROCESSING_INPUT), provider);
        }
        if (tag.contains(TAG_PROCESSING_OUTPUT)) {
            this.processingOutput.fromTag(tag.getCompound(TAG_PROCESSING_OUTPUT), provider);
        }
        if (tag.contains(TAG_STONECUTTER_INPUT)) {
            ContainerUtil.read(tag.getCompound(TAG_STONECUTTER_INPUT), (Container)this.stonecutterInput, provider);
        }
        this.stonecutterInput.setSelectedRecipe(tag.getInt(TAG_STONECUTTER_SELECTED_RECIPE));
        if (tag.contains(TAG_SMITHING_INPUT)) {
            this.smithingTableRecipe.readFromTag(tag.getCompound(TAG_SMITHING_INPUT), provider);
        }
        if (tag.contains(TAG_CRAFTING_INPUT)) {
            this.craftingRecipe.readFromTag(tag.getCompound(TAG_CRAFTING_INPUT), provider);
        }
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.craftingRecipe.updateResult(level);
        this.stonecutterInput.updateRecipes(level);
        this.smithingTableRecipe.updateResult(level);
    }

    boolean isFuzzyMode() {
        return this.fuzzyMode;
    }

    PatternType getPatternType() {
        return this.patternType;
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.fuzzyMode = fuzzyMode;
        this.setChanged();
    }

    void setPatternType(PatternType patternType) {
        this.patternType = patternType;
        this.setChanged();
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.PATTERN_GRID);
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new PatternGridContainerMenu(syncId, inventory, this);
    }

    @Override
    public PatternGridData getMenuData() {
        return new PatternGridData(GridData.of(this), this.patternType, ProcessingInputData.of(this.processingInput), ResourceContainerData.of(this.processingOutput), this.stonecutterInput.getSelectedRecipe());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, PatternGridData> getMenuCodec() {
        return PatternGridData.STREAM_CODEC;
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.add((Object)this.patternInput.getItem(0));
        drops.add((Object)this.patternOutput.getItem(0));
        return drops;
    }

    void clear() {
        if (this.level == null) {
            return;
        }
        switch (this.patternType) {
            case CRAFTING: {
                this.craftingRecipe.clear(this.level);
                break;
            }
            case PROCESSING: {
                this.clearProcessing();
                break;
            }
            case STONECUTTER: {
                this.stonecutterInput.clearContent();
                break;
            }
            case SMITHING_TABLE: {
                this.smithingTableRecipe.clear(this.level);
            }
        }
        this.setChanged();
    }

    private void clearProcessing() {
        this.processingInput.clear();
        this.processingOutput.clear();
    }

    void createPattern() {
        ItemStack result;
        if (this.level == null || !this.isPatternAvailable()) {
            return;
        }
        switch (this.patternType) {
            default: {
                throw new MatchException(null, null);
            }
            case CRAFTING: {
                ItemStack itemStack = this.createCraftingPattern();
                break;
            }
            case PROCESSING: {
                ItemStack itemStack = this.createProcessingPattern();
                break;
            }
            case STONECUTTER: {
                ItemStack itemStack = this.createStonecutterPattern();
                break;
            }
            case SMITHING_TABLE: {
                ItemStack itemStack = result = this.createSmithingTablePattern();
            }
        }
        if (result != null) {
            boolean shouldExtractInputPattern = this.patternOutput.getItem(0).isEmpty();
            if (shouldExtractInputPattern) {
                this.patternInput.removeItem(0, 1);
            }
            this.patternOutput.setItem(0, result);
        }
    }

    @Nullable
    private ItemStack createCraftingPattern() {
        if (!this.craftingRecipe.hasResult()) {
            return null;
        }
        ItemStack result = PatternGridBlockEntity.createPatternStack(PatternType.CRAFTING);
        CraftingPatternState state = new CraftingPatternState(this.fuzzyMode, this.getCraftingMatrix().asPositionedCraftInput());
        result.set(DataComponents.INSTANCE.getCraftingPatternState(), (Object)state);
        return result;
    }

    @Nullable
    private ItemStack createProcessingPattern() {
        if (this.processingInput.isEmpty() || this.processingOutput.isEmpty()) {
            return null;
        }
        ItemStack result = PatternGridBlockEntity.createPatternStack(PatternType.PROCESSING);
        ArrayList<Optional<ProcessingPatternState.ProcessingIngredient>> ingredients = new ArrayList<Optional<ProcessingPatternState.ProcessingIngredient>>();
        for (int i = 0; i < this.processingInput.size(); ++i) {
            ingredients.add(this.processingInput.getIngredient(i));
        }
        ArrayList<Optional<ResourceAmount>> outputs = new ArrayList<Optional<ResourceAmount>>();
        for (int i = 0; i < this.processingOutput.size(); ++i) {
            outputs.add(Optional.ofNullable(this.processingOutput.get(i)));
        }
        ProcessingPatternState patternProcessingState = new ProcessingPatternState(ingredients, outputs);
        result.set(DataComponents.INSTANCE.getProcessingPatternState(), (Object)patternProcessingState);
        return result;
    }

    @Nullable
    private ItemStack createStonecutterPattern() {
        if (this.stonecutterInput.getItem(0).isEmpty() || !this.stonecutterInput.hasSelectedRecipe() || this.level == null) {
            return null;
        }
        ItemStack input = this.stonecutterInput.getItem(0);
        List<RecipeHolder<StonecutterRecipe>> recipes = this.stonecutterInput.getRecipes();
        int selectedRecipe = this.stonecutterInput.getSelectedRecipe();
        if (selectedRecipe < 0 || selectedRecipe >= recipes.size()) {
            return null;
        }
        ItemStack selectedOutput = ((StonecutterRecipe)recipes.get(selectedRecipe).value()).assemble(new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
        if (selectedOutput.isEmpty()) {
            return null;
        }
        ItemStack result = PatternGridBlockEntity.createPatternStack(PatternType.STONECUTTER);
        StonecutterPatternState state = new StonecutterPatternState(ItemResource.ofItemStack(input), ItemResource.ofItemStack(selectedOutput));
        result.set(DataComponents.INSTANCE.getStonecutterPatternState(), (Object)state);
        return result;
    }

    @Nullable
    private ItemStack createSmithingTablePattern() {
        if (!this.smithingTableRecipe.hasResult()) {
            return null;
        }
        ItemStack result = PatternGridBlockEntity.createPatternStack(PatternType.SMITHING_TABLE);
        SmithingTablePatternState state = new SmithingTablePatternState(ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().getItem(0)), ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().getItem(1)), ItemResource.ofItemStack(this.smithingTableRecipe.getMatrix().getItem(2)));
        result.set(DataComponents.INSTANCE.getSmithingTablePatternState(), (Object)state);
        return result;
    }

    public static ItemStack createPatternStack(PatternType patternType) {
        ItemStack result = new ItemStack((ItemLike)Items.INSTANCE.getPattern());
        PatternState patternState = new PatternState(UUID.randomUUID(), patternType);
        result.set(DataComponents.INSTANCE.getPatternState(), (Object)patternState);
        return result;
    }

    void copyPattern(ItemStack stack) {
        PatternState patternState = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        if (patternState == null) {
            return;
        }
        this.patternType = patternState.type();
        switch (patternState.type()) {
            case CRAFTING: {
                CraftingPatternState state = (CraftingPatternState)stack.get(DataComponents.INSTANCE.getCraftingPatternState());
                if (state == null) break;
                this.copyCraftingPattern(state);
                break;
            }
            case PROCESSING: {
                ProcessingPatternState state = (ProcessingPatternState)stack.get(DataComponents.INSTANCE.getProcessingPatternState());
                if (state == null) break;
                this.copyProcessingPattern(state);
                break;
            }
            case STONECUTTER: {
                StonecutterPatternState state = (StonecutterPatternState)stack.get(DataComponents.INSTANCE.getStonecutterPatternState());
                if (state == null) break;
                this.copyStonecutterPattern(state);
                break;
            }
            case SMITHING_TABLE: {
                SmithingTablePatternState state = (SmithingTablePatternState)stack.get(DataComponents.INSTANCE.getSmithingTablePatternState());
                if (state == null) break;
                this.copySmithingTablePattern(state);
            }
        }
        this.setChanged();
    }

    private void copyCraftingPattern(CraftingPatternState state) {
        this.fuzzyMode = state.fuzzyMode();
        this.craftingRecipe.getMatrix().clearContent();
        CraftingInput.Positioned positionedInput = state.input();
        int left = positionedInput.left();
        int top = positionedInput.top();
        CraftingInput input = positionedInput.input();
        for (int x = 0; x < input.width(); ++x) {
            for (int y = 0; y < input.height(); ++y) {
                int matrixIndex = x + left + (y + top) * this.craftingRecipe.getMatrix().getWidth();
                int recipeIndex = x + y * input.width();
                ItemStack stack = input.getItem(recipeIndex);
                this.craftingRecipe.getMatrix().setItem(matrixIndex, stack);
            }
        }
        if (this.level != null) {
            this.craftingRecipe.updateResult(this.level);
        }
    }

    private void copyProcessingPattern(ProcessingPatternState state) {
        int ii;
        int i;
        this.clearProcessing();
        for (i = 0; i < state.ingredients().size(); ++i) {
            ii = i;
            state.ingredients().get(i).ifPresent(processingIngredient -> this.processingInput.set(ii, (ProcessingPatternState.ProcessingIngredient)processingIngredient));
        }
        for (i = 0; i < state.outputs().size(); ++i) {
            ii = i;
            state.outputs().get(i).ifPresent(amount -> this.processingOutput.set(ii, (ResourceAmount)amount));
        }
    }

    private void copyStonecutterPattern(StonecutterPatternState state) {
        ItemResource input = state.input();
        ItemResource selectedOutput = state.selectedOutput();
        this.setStonecutterInputAndSelectedRecipe(input.toItemStack(), selectedOutput.toItemStack());
    }

    private void setStonecutterInputAndSelectedRecipe(ItemStack input, ItemStack selectedOutput) {
        if (this.level == null) {
            return;
        }
        this.stonecutterInput.clearContent();
        this.stonecutterInput.setSelectedRecipe(-1);
        this.stonecutterInput.setItem(0, input);
        for (int i = 0; i < this.stonecutterInput.getRecipes().size(); ++i) {
            ItemStack result = ((StonecutterRecipe)this.stonecutterInput.getRecipes().get(i).value()).assemble(new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)selectedOutput)) continue;
            this.stonecutterInput.setSelectedRecipe(i);
            return;
        }
    }

    private void copySmithingTablePattern(SmithingTablePatternState state) {
        ItemResource template = state.template();
        ItemResource base = state.base();
        ItemResource addition = state.addition();
        this.setSmithingTableInput(template.toItemStack(), base.toItemStack(), addition.toItemStack());
    }

    private void setSmithingTableInput(ItemStack template, ItemStack base, ItemStack addition) {
        this.smithingTableRecipe.getMatrix().clearContent();
        this.smithingTableRecipe.getMatrix().setItem(0, template);
        this.smithingTableRecipe.getMatrix().setItem(1, base);
        this.smithingTableRecipe.getMatrix().setItem(2, addition);
        if (this.level != null) {
            this.smithingTableRecipe.updateResult(this.level);
        }
    }

    private boolean isPatternAvailable() {
        return !this.patternInput.getItem(0).isEmpty() || !this.patternOutput.getItem(0).isEmpty();
    }

    void transferCraftingRecipe(Player player, List<List<ItemResource>> recipe) {
        Comparator<ResourceKey> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.getInventory(), r -> r);
        this.getCraftingMatrix().clearContent();
        for (int i = 0; i < this.getCraftingMatrix().getContainerSize() && i < recipe.size(); ++i) {
            List<ItemResource> possibilities = recipe.get(i);
            if (possibilities.isEmpty()) continue;
            possibilities.sort(sorter);
            this.getCraftingMatrix().setItem(i, possibilities.getFirst().toItemStack());
        }
        this.setPatternType(PatternType.CRAFTING);
    }

    void transferProcessingRecipe(Player player, List<List<ResourceAmount>> inputs, List<List<ResourceAmount>> outputs) {
        Comparator<ResourceAmount> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.getInventory(), ResourceAmount::resource);
        this.getProcessingInput().clear();
        this.transferProcessingRecipe(inputs, this.getProcessingInput(), sorter);
        this.getProcessingOutput().clear();
        this.transferProcessingRecipe(outputs, this.getProcessingOutput(), sorter);
        this.setPatternType(PatternType.PROCESSING);
    }

    private void transferProcessingRecipe(List<List<ResourceAmount>> recipe, ResourceContainer container, Comparator<ResourceAmount> sorter) {
        for (int i = 0; i < container.size() && i < recipe.size(); ++i) {
            List<ResourceAmount> possibilities = recipe.get(i);
            if (possibilities.isEmpty()) continue;
            possibilities.sort(sorter);
            container.set(i, possibilities.getFirst());
        }
    }

    void transferStonecutterRecipe(ItemResource input, ItemResource selectedOutput) {
        this.setStonecutterInputAndSelectedRecipe(input.toItemStack(), selectedOutput.toItemStack());
        this.setPatternType(PatternType.STONECUTTER);
    }

    void transferSmithingTableRecipe(Player player, List<ItemResource> templates, List<ItemResource> bases, List<ItemResource> additions) {
        if (templates.isEmpty() || bases.isEmpty() || additions.isEmpty()) {
            return;
        }
        Comparator<ItemResource> sorter = ResourceSorters.create(((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? (RootStorage)((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(StorageNetworkComponent.class) : null, ((GridNetworkNode)this.mainNetworkNode).getNetwork() != null ? ((GridNetworkNode)this.mainNetworkNode).getNetwork().getComponent(AutocraftingNetworkComponent.class).getPatterns() : Collections.emptySet(), player.getInventory(), r -> r);
        templates.sort(sorter);
        bases.sort(sorter);
        additions.sort(sorter);
        ItemResource template = templates.getFirst();
        ItemResource base = bases.getFirst();
        ItemResource addition = additions.getFirst();
        this.setSmithingTableInput(template.toItemStack(), base.toItemStack(), addition.toItemStack());
        this.setPatternType(PatternType.SMITHING_TABLE);
    }

    static boolean isValidPattern(ItemStack stack) {
        return stack.getItem() instanceof PatternItem;
    }

    static ProcessingMatrixInputResourceContainer createProcessingMatrixInputContainer() {
        return new ProcessingMatrixInputResourceContainer(81, PatternGridBlockEntity::getProcessingPatternLimit, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ProcessingMatrixInputResourceContainer createProcessingMatrixInputContainer(ProcessingInputData data) {
        ProcessingMatrixInputResourceContainer filterContainer = PatternGridBlockEntity.createProcessingMatrixInputContainer();
        ResourceContainerImpl.setResourceContainerData(data.resourceContainerData().resources(), filterContainer);
        for (int i = 0; i < data.allowedTagIds().size(); ++i) {
            filterContainer.setAllowedTagIds(i, data.allowedTagIds().get(i));
        }
        return filterContainer;
    }

    static ResourceContainer createProcessingMatrixOutputContainer() {
        return new ResourceContainerImpl(81, PatternGridBlockEntity::getProcessingPatternLimit, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ResourceContainer createProcessingMatrixOutputContainer(ResourceContainerData data) {
        ResourceContainer filterContainer = PatternGridBlockEntity.createProcessingMatrixOutputContainer();
        ResourceContainerImpl.setResourceContainerData(data.resources(), filterContainer);
        return filterContainer;
    }

    private static long getProcessingPatternLimit(ResourceKey resource) {
        long l;
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            l = platformResource.getProcessingPatternLimit();
        } else {
            l = 1L;
        }
        return l;
    }
}

