/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.VanillaConstants;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

class SmithingTablePatternGridRenderer
implements PatternGridRenderer {
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("pattern_grid/smithing_table");
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int topPos;
    private final int x;
    private final int y;
    private final CyclingSlotBackground templateIcon;
    private final CyclingSlotBackground baseIcon;
    private final CyclingSlotBackground additionalIcon;
    @Nullable
    private ArmorStand preview;
    private ItemStack result = ItemStack.EMPTY;

    SmithingTablePatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int topPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.x = x;
        this.y = y;
        this.templateIcon = new CyclingSlotBackground(menu.getFirstSmithingTableSlotIndex());
        this.baseIcon = new CyclingSlotBackground(menu.getFirstSmithingTableSlotIndex() + 1);
        this.additionalIcon = new CyclingSlotBackground(menu.getFirstSmithingTableSlotIndex() + 2);
    }

    @Override
    public void addWidgets(Consumer<AbstractWidget> widgets, Consumer<AbstractWidget> renderables) {
        Level level = ClientPlatformUtil.getClientLevel();
        if (level == null) {
            return;
        }
        this.preview = new ArmorStand(level, 0.0, 0.0, 0.0);
        this.preview.setNoBasePlate(true);
        this.preview.setShowArms(true);
        this.preview.yBodyRot = 210.0f;
        this.preview.setXRot(25.0f);
        this.preview.yHeadRot = this.preview.getYRot();
        this.preview.yHeadRotO = this.preview.getYRot();
        this.result = this.menu.getSmithingTableResult().copy();
        this.updatePreview();
    }

    @Override
    public void tick() {
        ItemStack currentResult = this.menu.getSmithingTableResult();
        if (!ItemStack.isSameItemSameComponents((ItemStack)currentResult, (ItemStack)this.result)) {
            this.result = currentResult.copy();
            this.updatePreview();
        }
        Optional<SmithingTemplateItem> templateItem = this.menu.getSmithingTableTemplateItem();
        this.templateIcon.tick(VanillaConstants.EMPTY_SLOT_SMITHING_TEMPLATES);
        this.baseIcon.tick(templateItem.map(SmithingTemplateItem::getBaseSlotEmptyIcons).orElse(List.of()));
        this.additionalIcon.tick(templateItem.map(SmithingTemplateItem::getAdditionalSlotEmptyIcons).orElse(List.of()));
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 112;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 26;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.enableScissor(this.x, this.y, this.x + 138, this.y + 71);
        graphics.blitSprite(SPRITE, this.x + 4, this.y + 26, 98, 18);
        this.renderIcons(graphics, partialTicks);
        if (this.preview != null) {
            InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)((float)this.x + 128.0f), (float)((float)this.y + 52.0f), (float)25.0f, (Vector3f)VanillaConstants.ARMOR_STAND_TRANSLATION, (Quaternionf)VanillaConstants.ARMOR_STAND_ANGLE, null, (LivingEntity)this.preview);
        }
        graphics.disableScissor();
    }

    private void renderIcons(GuiGraphics graphics, float partialTicks) {
        this.templateIcon.render((AbstractContainerMenu)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
        this.baseIcon.render((AbstractContainerMenu)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
        this.additionalIcon.render((AbstractContainerMenu)this.menu, graphics, partialTicks, this.leftPos, this.topPos);
    }

    @Override
    public void renderTooltip(Font font, @Nullable Slot hoveredSlot, GuiGraphics graphics, int mouseX, int mouseY) {
        if (hoveredSlot == null || hoveredSlot.hasItem()) {
            return;
        }
        int firstSlotIndex = this.menu.getFirstSmithingTableSlotIndex();
        this.menu.getSmithingTableTemplateItem().ifPresentOrElse(template -> {
            if (hoveredSlot.index == firstSlotIndex + 1) {
                graphics.renderTooltip(font, SmithingTablePatternGridRenderer.split(font, template.getBaseSlotDescription()), mouseX, mouseY);
            } else if (hoveredSlot.index == firstSlotIndex + 2) {
                graphics.renderTooltip(font, SmithingTablePatternGridRenderer.split(font, template.getAdditionSlotDescription()), mouseX, mouseY);
            }
        }, () -> {
            if (hoveredSlot.index == firstSlotIndex) {
                graphics.renderTooltip(font, SmithingTablePatternGridRenderer.split(font, VanillaConstants.MISSING_SMITHING_TEMPLATE_TOOLTIP), mouseX, mouseY);
            }
        });
    }

    private static List<FormattedCharSequence> split(Font font, Component template) {
        return font.split((FormattedText)template, 115);
    }

    private void updatePreview() {
        if (this.preview == null) {
            return;
        }
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            this.preview.setItemSlot(equipmentslot, ItemStack.EMPTY);
        }
        if (this.result.isEmpty()) {
            return;
        }
        Item item = this.result.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            this.preview.setItemSlot(armorItem.getEquipmentSlot(), this.result);
        } else {
            this.preview.setItemSlot(EquipmentSlot.OFFHAND, this.result);
        }
    }
}

