/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManagerImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.EmptyGridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.NoopStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.FuzzyGridOperations;
import com.refinedmods.refinedstorage.common.grid.SecuredGridOperations;
import com.refinedmods.refinedstorage.common.grid.WirelessGridOperations;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

class WirelessGrid
implements Grid {
    private final NetworkItemContext context;
    private final GridWatcherManager watchers = new GridWatcherManagerImpl();

    WirelessGrid(NetworkItemContext context) {
        this.context = context;
    }

    private Optional<StorageNetworkComponent> getStorage() {
        return this.context.resolveNetwork().map(network -> network.getComponent(StorageNetworkComponent.class));
    }

    private Optional<PlatformSecurityNetworkComponent> getSecurity() {
        return this.context.resolveNetwork().map(network -> network.getComponent(PlatformSecurityNetworkComponent.class));
    }

    private Optional<AutocraftingNetworkComponent> getAutocrafting() {
        return this.context.resolveNetwork().map(network -> network.getComponent(AutocraftingNetworkComponent.class));
    }

    @Override
    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.context.drainEnergy(Platform.INSTANCE.getConfig().getWirelessGrid().getOpenEnergyUsage());
        StorageNetworkComponent storage = this.context.resolveNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).orElse(null);
        this.watchers.addWatcher(watcher, actorType, storage);
    }

    @Override
    public void removeWatcher(GridWatcher watcher) {
        StorageNetworkComponent storage = this.context.resolveNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).orElse(null);
        this.watchers.removeWatcher(watcher, storage);
    }

    @Override
    public Storage getItemStorage() {
        return this.getStorage().map(Storage.class::cast).orElseGet(NoopStorage::new);
    }

    @Override
    public boolean isGridActive() {
        boolean networkActive = this.context.resolveNetwork().map(network -> network.getComponent(EnergyNetworkComponent.class).getStored() > 0L).orElse(false);
        return networkActive && this.context.isActive();
    }

    @Override
    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return this.getStorage().map(storage -> storage.getResources(actorType)).orElse(Collections.emptyList());
    }

    @Override
    public Set<PlatformResourceKey> getAutocraftableResources() {
        return this.getAutocrafting().map(AutocraftingNetworkComponent::getOutputs).map(outputs -> outputs.stream().filter(PlatformResourceKey.class::isInstance).map(PlatformResourceKey.class::cast).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public GridOperations createOperations(ResourceType resourceType, ServerPlayer player) {
        return this.getStorage().flatMap(rootStorage -> this.getSecurity().map(security -> this.createGridOperations(resourceType, player, (RootStorage)rootStorage, (PlatformSecurityNetworkComponent)security))).map(operations -> new WirelessGridOperations((GridOperations)operations, this.context, this.watchers)).orElse(EmptyGridOperations.INSTANCE);
    }

    @Override
    public boolean canMenuStayOpen(Player player) {
        return true;
    }

    private GridOperations createGridOperations(ResourceType resourceType, ServerPlayer player, RootStorage rootStorage, PlatformSecurityNetworkComponent securityNetworkComponent) {
        PlayerActor playerActor = new PlayerActor((Player)player);
        GridOperations operations = resourceType.createGridOperations(rootStorage, playerActor);
        SecuredGridOperations secured = new SecuredGridOperations(player, securityNetworkComponent, operations);
        if (rootStorage instanceof FuzzyRootStorage) {
            FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
            return new FuzzyGridOperations(player, fuzzyRootStorage, secured);
        }
        return secured;
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.getPreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.getTreePreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return this.getAutocrafting().map(autocrafting -> autocrafting.getMaxAmount(resource, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    @Override
    public Optional<TaskId> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        return this.getAutocrafting().flatMap(autocrafting -> autocrafting.startTask(resource, amount, actor, notify, cancellationToken));
    }
}

