/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemGridResourceRepositoryMapper
implements ResourceRepositoryMapper<GridResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractItemGridResourceRepositoryMapper.class);

    @Override
    public GridResource apply(ResourceKey resource) {
        ItemResource itemResource = (ItemResource)resource;
        Item item = itemResource.item();
        ItemStack itemStack = itemResource.toItemStack();
        String name = item.getName(itemStack).getString();
        String modId = this.getModId(itemStack);
        String modName = this.getModName(modId).orElse("");
        Map<GridResourceAttributeKeys, Supplier> attributes = Map.of(GridResourceAttributeKeys.MOD_ID, Suppliers.ofInstance(Set.of(modId)), GridResourceAttributeKeys.MOD_NAME, Suppliers.ofInstance(Set.of(modName)), GridResourceAttributeKeys.TAGS, Suppliers.memoize(() -> this.getTags(item)), GridResourceAttributeKeys.TOOLTIP, Suppliers.memoize(() -> Set.of(this.getTooltip(itemStack))));
        return new ItemGridResource(itemResource, itemStack, name, k -> (Set)attributes.getOrDefault(k, Collections::emptySet).get());
    }

    private String getTooltip(ItemStack itemStack) {
        try {
            return itemStack.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.ADVANCED).stream().map(Component::getString).collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to get tooltip for item {}", (Object)itemStack, (Object)t);
            return "";
        }
    }

    private Set<String> getTags(Item item) {
        return BuiltInRegistries.ITEM.getResourceKey((Object)item).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getHolder(arg_0)).stream().flatMap(Holder::tags).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
    }

    public abstract String getModId(ItemStack var1);

    public abstract Optional<String> getModName(String var1);
}

