/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.impl.node.security.SecurityDecisionProviderProxyNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.security.SecurityDecisionProviderImpl;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.SecurityHelper;
import com.refinedmods.refinedstorage.common.api.security.SecurityPolicyContainerItem;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.SecurityManagerConnectionStrategy;
import com.refinedmods.refinedstorage.common.security.SecurityManagerContainerMenu;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeContainerProviderImpl;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class SecurityManagerBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SecurityDecisionProviderProxyNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeMenuProvider {
    static final int CARD_AMOUNT = 18;
    private static final String TAG_SECURITY_CARDS = "sc";
    private static final String TAG_FALLBACK_SECURITY_CARD = "fsc";
    private final FilteredContainer securityCards = new FilteredContainer(18, SecurityManagerBlockEntity::isValidSecurityCard);
    private final FilteredContainer fallbackSecurityCard = new FilteredContainer(1, SecurityManagerBlockEntity::isValidFallbackSecurityCard);
    private final SecurityDecisionProviderImpl securityDecisionProvider = new SecurityDecisionProviderImpl();

    public SecurityManagerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getSecurityManager(), pos, state, new SecurityDecisionProviderProxyNetworkNode(Platform.INSTANCE.getConfig().getSecurityManager().getEnergyUsage()));
        this.securityCards.addListener(card -> this.invalidate());
        this.fallbackSecurityCard.addListener(card -> this.invalidate());
        ((SecurityDecisionProviderProxyNetworkNode)this.mainNetworkNode).setDelegate(this.securityDecisionProvider);
    }

    @Override
    protected NetworkNodeContainerProvider createContainerProvider() {
        return new NetworkNodeContainerProviderImpl(){

            @Override
            public boolean canBuild(ServerPlayer player) {
                return super.canBuild(player) || SecurityManagerBlockEntity.this.isPlacedBy(player.getGameProfile().getId());
            }
        };
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(SecurityDecisionProviderProxyNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new SecurityManagerConnectionStrategy(() -> ((SecurityManagerBlockEntity)this).getBlockState(), this.getBlockPos())).build();
    }

    private void invalidate() {
        if (this.level != null) {
            this.setChanged();
        }
        this.securityDecisionProvider.clearPolicies();
        long energyUsage = Platform.INSTANCE.getConfig().getSecurityManager().getEnergyUsage();
        for (int i = 0; i < this.securityCards.getContainerSize(); ++i) {
            ItemStack securityCard = this.securityCards.getItem(i);
            Item item = securityCard.getItem();
            if (!(item instanceof SecurityPolicyContainerItem)) continue;
            SecurityPolicyContainerItem securityPolicyContainerItem = (SecurityPolicyContainerItem)item;
            energyUsage += securityPolicyContainerItem.getEnergyUsage();
            securityPolicyContainerItem.getPolicy(securityCard).ifPresent(policy -> securityPolicyContainerItem.getActor(securityCard).ifPresent(actor -> this.securityDecisionProvider.setPolicy((SecurityActor)actor, (SecurityPolicy)policy)));
        }
        ((SecurityDecisionProviderProxyNetworkNode)this.mainNetworkNode).setEnergyUsage(energyUsage += this.updateDefaultPolicyAndGetEnergyUsage());
    }

    private long updateDefaultPolicyAndGetEnergyUsage() {
        ItemStack fallbackSecurityCardStack = this.fallbackSecurityCard.getItem(0);
        Item item = fallbackSecurityCardStack.getItem();
        if (item instanceof SecurityPolicyContainerItem) {
            SecurityPolicyContainerItem securityPolicyContainerItem = (SecurityPolicyContainerItem)item;
            securityPolicyContainerItem.getPolicy(fallbackSecurityCardStack).ifPresentOrElse(this.securityDecisionProvider::setDefaultPolicy, () -> this.securityDecisionProvider.setDefaultPolicy(null));
            return securityPolicyContainerItem.getEnergyUsage();
        }
        this.securityDecisionProvider.setDefaultPolicy(null);
        return 0L;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_SECURITY_CARDS)) {
            ContainerUtil.read(tag.getCompound(TAG_SECURITY_CARDS), (Container)this.securityCards, provider);
        }
        if (tag.contains(TAG_FALLBACK_SECURITY_CARD)) {
            ContainerUtil.read(tag.getCompound(TAG_FALLBACK_SECURITY_CARD), (Container)this.fallbackSecurityCard, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_SECURITY_CARDS, (Tag)ContainerUtil.write((Container)this.securityCards, provider));
        tag.put(TAG_FALLBACK_SECURITY_CARD, (Tag)ContainerUtil.write((Container)this.fallbackSecurityCard, provider));
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.securityCards.getContainerSize(); ++i) {
            drops.add((Object)this.securityCards.getItem(i));
        }
        drops.add((Object)this.fallbackSecurityCard.getItem(0));
        return drops;
    }

    FilteredContainer getSecurityCards() {
        return this.securityCards;
    }

    FilteredContainer getFallbackSecurityCard() {
        return this.fallbackSecurityCard;
    }

    static boolean isValidSecurityCard(ItemStack stack) {
        SecurityPolicyContainerItem securityPolicyContainerItem;
        Item item = stack.getItem();
        return item instanceof SecurityPolicyContainerItem && (securityPolicyContainerItem = (SecurityPolicyContainerItem)item).isValid(stack) && !(stack.getItem() instanceof FallbackSecurityCardItem);
    }

    static boolean isValidFallbackSecurityCard(ItemStack stack) {
        return stack.getItem() instanceof FallbackSecurityCardItem;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.SECURITY_MANAGER);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new SecurityManagerContainerMenu(syncId, inventory, this);
    }

    @Override
    public boolean canOpen(ServerPlayer player) {
        boolean isAllowedViaSecuritySystem = NetworkNodeMenuProvider.super.canOpen(player) && SecurityHelper.isAllowed(player, (Permission)BuiltinPermission.SECURITY, this.containers.getContainers());
        return isAllowedViaSecuritySystem || this.isPlacedBy(player.getGameProfile().getId());
    }
}

