/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.storage.ErrorHandlingMapCodec;
import com.refinedmods.refinedstorage.common.support.AbstractPlatformSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public class StorageRepositoryImpl
extends AbstractPlatformSavedData
implements StorageRepository {
    public static final String NAME = "refinedstorage_storages";
    private final Codec<Map<UUID, SerializableStorage>> codec = StorageRepositoryImpl.createCodec(this::markAsChanged);
    private final Map<UUID, SerializableStorage> entries;

    public StorageRepositoryImpl(CompoundTag tag, HolderLookup.Provider provider) {
        this.entries = new HashMap<UUID, SerializableStorage>((Map)((Pair)this.codec.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow()).getFirst());
    }

    public StorageRepositoryImpl() {
        this.entries = new HashMap<UUID, SerializableStorage>();
    }

    private static Codec<Map<UUID, SerializableStorage>> createCodec(Runnable listener) {
        Codec storageCodec = RefinedStorageApi.INSTANCE.getStorageTypeRegistry().codec().dispatch(SerializableStorage::getType, storage -> storage.getMapCodec(listener));
        return new ErrorHandlingMapCodec<UUID, SerializableStorage>(UUIDUtil.STRING_CODEC, storageCodec);
    }

    @Override
    public Optional<SerializableStorage> get(UUID id) {
        return Optional.ofNullable(this.entries.get(id));
    }

    @Override
    public void set(UUID id, SerializableStorage storage) {
        CoreValidations.validateNotNull(storage, "Storage must not be null");
        CoreValidations.validateNotNull(id, "ID must not be null");
        if (this.entries.containsKey(id)) {
            throw new IllegalArgumentException(String.valueOf(id) + " already exists");
        }
        this.entries.put(id, storage);
        this.setDirty();
    }

    @Override
    public Optional<SerializableStorage> removeIfEmpty(UUID id) {
        return this.get(id).map(storage -> {
            if (storage.getStored() == 0L) {
                this.remove(id);
                return storage;
            }
            return null;
        });
    }

    @Override
    public void remove(UUID id) {
        this.entries.remove(id);
        this.setDirty();
    }

    @Override
    public StorageInfo getInfo(UUID id) {
        return this.get(id).map(StorageInfo::of).orElse(StorageInfo.UNKNOWN);
    }

    @Override
    public void markAsChanged() {
        this.setDirty();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        return (CompoundTag)this.codec.encode(this.entries, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }
}

