/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.s2c;

import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record NetworkTransmitterStatusPacket(boolean error, boolean transmitting, Component message) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NetworkTransmitterStatusPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("network_transmitter_status"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NetworkTransmitterStatusPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, NetworkTransmitterStatusPacket::error, (StreamCodec)ByteBufCodecs.BOOL, NetworkTransmitterStatusPacket::transmitting, (StreamCodec)ComponentSerialization.STREAM_CODEC, NetworkTransmitterStatusPacket::message, NetworkTransmitterStatusPacket::new);

    public static void handle(NetworkTransmitterStatusPacket packet, PacketContext ctx) {
        AbstractContainerMenu menu = ctx.getPlayer().containerMenu;
        if (menu instanceof NetworkTransmitterContainerMenu) {
            NetworkTransmitterContainerMenu containerMenu = (NetworkTransmitterContainerMenu)menu;
            containerMenu.setStatus(new NetworkTransmitterData(packet.error, packet.transmitting, packet.message));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

