/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.grid.strategy;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.neoforge.grid.strategy.CursorItemHandler;
import com.refinedmods.refinedstorage.neoforge.storage.CapabilityCache;
import com.refinedmods.refinedstorage.neoforge.storage.ItemHandlerInsertableStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class ItemGridExtractionStrategy
implements GridExtractionStrategy {
    private final GridOperations gridOperations;
    private final PlayerMainInvWrapper playerInventoryStorage;
    private final CursorItemHandler playerCursorItemHandler;

    public ItemGridExtractionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerInventoryStorage = new PlayerMainInvWrapper(player.getInventory());
        this.playerCursorItemHandler = new CursorItemHandler(containerMenu);
    }

    @Override
    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            CursorItemHandler handler = cursor ? this.playerCursorItemHandler : this.playerInventoryStorage;
            this.gridOperations.extract(itemResource, extractMode, new ItemHandlerInsertableStorage(CapabilityCache.ofItemHandler(handler)));
            return true;
        }
        return false;
    }
}

