/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.query.lexer;

import com.refinedmods.refinedstorage.query.lexer.TokenRange;

public class LexerPosition {
    private int startIndex = 0;
    private int endIndex = 0;
    private int startLine = 1;
    private int endLine = 1;
    private int startColumn = 1;
    private int endColumn = 1;

    public void nextLine() {
        ++this.endLine;
        this.endColumn = 1;
    }

    public void advance() {
        this.advance(1);
    }

    public void advance(int n) {
        this.endIndex += n;
        this.endColumn += n;
    }

    public void reset() {
        this.startIndex = this.endIndex;
        this.startLine = this.endLine;
        this.startColumn = this.endColumn;
    }

    public void advanceAndReset() {
        this.advance();
        this.reset();
    }

    public TokenRange createRange() {
        return new TokenRange(this.startLine, this.startColumn, this.endLine, this.endColumn - 1);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }
}

