/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BigRelicCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget {
    private RelicDescriptionScreen screen;

    public BigRelicCardWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 48, 74);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        LocalPlayer player = this.minecraft.player;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        GUIRenderer.begin(DescriptionTextures.BIG_CARD_FRAME_UNLOCKED_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX(), this.getY()).end();
        int xOff = 0;
        if (relic.hasUnlockedUpgradeableAbility(stack)) {
            for (int i = 0; i < 5; ++i) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_HOLE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 4, this.getY() + 63).end();
                xOff += 8;
            }
            xOff = 0;
            int quality = relic.getRelicQuality(stack);
            boolean isAliquot = quality % 2 == 1;
            int i = 0;
            while ((double)i < Math.floor((double)quality / 2.0)) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 4, this.getY() + 63).end();
                xOff += 8;
                ++i;
            }
            if (isAliquot) {
                GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + xOff + 4, this.getY() + 63).patternSize(4, 7).texSize(8, 7).end();
            }
        }
        poseStack.pushPose();
        float scale = 1.75f;
        poseStack.translate((double)((float)(this.getX() + 10) + 8.0f * scale), (double)(this.getY() + 21) + Math.sin(((float)player.tickCount + pPartialTick) * 0.1f) * 2.0 + (double)(8.0f * scale), 0.0);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.05f) * 5.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.075f) * 25.0f));
        poseStack.translate(-8.0f * scale, -8.0f * scale, -150.0f * scale);
        poseStack.scale(scale, scale, scale);
        guiGraphics.renderItem(stack, 0, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 1.0f);
        MutableComponent levelComponent = Component.literal((String)String.valueOf(relic.getRelicLevel(stack))).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(this.minecraft.font, (Component)levelComponent, (int)(((float)this.getX() + 25.5f) * 1.33f - (float)this.minecraft.font.width((FormattedText)levelComponent) / 2.0f), (int)((float)(this.getY() + 4) * 1.33f), 16769656, true);
        poseStack.popPose();
        if (this.isHovered() && relic.hasUnlockedUpgradeableAbility(stack)) {
            GUIRenderer.begin(DescriptionTextures.BIG_CARD_FRAME_OUTLINE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() - 1, this.getY() - 1).end();
        }
        poseStack.popPose();
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        ItemStack stack = this.screen.getStack();
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).hasUnlockedUpgradeableAbility(stack)) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.info.level").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + relic.getRelicLevel(stack) + "/" + relic.getLevelingData().getMaxLevel()), Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.info.quality").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + MathUtils.round((float)relic.getRelicQuality(stack) / 2.0f, 1) + "/" + relic.getMaxQuality() / 2), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"tooltip.relics.researching.relic.info.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.minecraft.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }
}

