/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.research.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.description.general.particles.base.ParticleData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ResearchParticleData
extends ParticleData {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/general/particles/pixel.png");
    private final float verticalAcceleration;

    public ResearchParticleData(Color color, float xStart, float yStart, float scale, int lifeTime, float verticalAcceleration) {
        super(TEXTURE, color, xStart, yStart, scale, lifeTime);
        this.verticalAcceleration = verticalAcceleration;
    }

    @Override
    public void tick(Screen screen) {
        super.tick(screen);
        LocalPlayer player = screen.getMinecraft().player;
        if (player == null) {
            return;
        }
        RandomSource random = player.getRandom();
        this.setX((float)((double)this.getX() + Math.sin((float)this.getLifeTime() * 0.15f) * (double)(0.1f + random.nextFloat() * 0.5f)));
        this.setY(this.getY() - (float)this.getLifeTime() * this.verticalAcceleration);
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        float lifePercentage = (float)this.getLifeTime() / (float)this.getMaxLifeTime();
        float blinkOffset = 0.25f + (float)(Math.sin((float)this.getLifeTime() + partialTick) * 0.5);
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)((float)this.getColor().getRed() / 255.0f + blinkOffset), (float)((float)this.getColor().getGreen() / 255.0f + blinkOffset), (float)((float)this.getColor().getBlue() / 255.0f + blinkOffset), (float)lifePercentage);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        poseStack.translate(Mth.lerp((float)partialTick, (float)this.getXO(), (float)this.getX()), Mth.lerp((float)partialTick, (float)this.getYO(), (float)this.getY()), 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(((float)this.getLifeTime() + partialTick) * 25.0f));
        GUIRenderer.begin(TEXTURE, guiGraphics.pose()).scale(this.getScale() * lifePercentage).anchor(SpriteAnchor.CENTER).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

