/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.entities.DeathEssenceEntity;
import it.hurts.sskirillss.relics.entities.LifeEssenceEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Locale;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class HolyLocketItem
extends RelicItem {
    private static final int MAX_TARGETS = 10;

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("faith").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).icon((Function3<Player, ItemStack, String, String>)((Function3)(player, stack, ability) -> ability + "_" + this.getMode((ItemStack)stack).name().toLowerCase(Locale.ROOT))).stat(StatData.builder("health").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatData.builder("damage").initialValue(0.25, 0.75).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).stat(StatData.builder("radius").initialValue(5.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).research(ResearchData.builder().star(0, 13, 5).star(1, 6, 8).star(2, 10, 12).star(3, 4, 13).star(4, 18, 13).star(5, 8, 16).star(6, 14, 16).star(7, 5, 20).star(8, 17, 20).star(9, 11, 24).star(10, 8, 28).star(11, 14, 28).link(0, 2).link(0, 4).link(1, 2).link(1, 3).link(3, 5).link(4, 6).link(5, 6).link(3, 7).link(4, 8).link(7, 9).link(8, 9).link(9, 10).link(9, 11).link(10, 11).build()).build()).ability(AbilityData.builder("penitence").requiredLevel(5).stat(StatData.builder("amount").initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> (int)MathUtils.round(value * 100.0, 0)).build()).research(ResearchData.builder().star(0, 7, 12).star(1, 15, 12).star(2, 6, 19).star(3, 16, 19).star(4, 9, 26).star(5, 13, 26).link(0, 1).link(0, 2).link(1, 3).link(2, 4).link(3, 5).link(4, 5).build()).build()).ability(AbilityData.builder("ascension").requiredLevel(10).requiredPoints(3).maxLevel(5).stat(StatData.builder("max_duration").initialValue(7.5, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.3195).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("duration").initialValue(0.5, 1.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).research(ResearchData.builder().star(0, 11, 27).star(1, 3, 19).star(2, 3, 4).star(3, 11, 17).star(4, 6, 13).star(5, 11, 13).star(6, 16, 13).star(7, 19, 19).star(8, 19, 4).link(0, 1).link(0, 3).link(0, 7).link(1, 2).link(2, 8).link(7, 8).link(3, 4).link(3, 5).link(3, 6).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(20).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder("faith").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).source(LevelingSourceData.abilityBuilder("penitence").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).source(LevelingSourceData.abilityBuilder("ascension").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).style(StyleData.builder().tooltip((player, stack) -> this.getMode((ItemStack)stack) == Mode.HOLINESS ? TooltipData.builder().borderTop(-3454452).borderBottom(-6540535).textured(true).icon("holy_locket_holiness").build() : TooltipData.builder().borderTop(-12039087).borderBottom(-12039087).textured(true).icon("holy_locket_wickedness").build()).beams((player, stack) -> this.getMode((ItemStack)stack) == Mode.HOLINESS ? BeamsData.builder().startColor(-256).endColor(0xFF0000).build() : BeamsData.builder().startColor(-16711681).endColor(255).build()).build()).loot(LootData.builder().entry(LootEntries.DESERT).build()).build();
    }

    public Mode getMode(ItemStack stack) {
        return Mode.byIndex((Integer)stack.getOrDefault(DataComponentRegistry.MODE, (Object)Mode.HOLINESS.getIndex()));
    }

    public void setMode(ItemStack stack, Mode mode) {
        stack.set(DataComponentRegistry.MODE, (Object)mode.getIndex());
    }

    public void cycleMode(ItemStack stack, int steps) {
        this.setMode(stack, this.getMode(stack).cycle(steps));
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("faith") && stage == CastStage.END) {
            this.cycleMode(stack, 1);
        }
    }

    public static enum Mode {
        HOLINESS(1),
        WICKEDNESS(2);

        private final int index;

        public static Mode byIndex(int index) {
            for (Mode mode : Mode.values()) {
                if (mode.getIndex() != index) continue;
                return mode;
            }
            throw new IllegalArgumentException();
        }

        public Mode cycle(int steps) {
            Mode[] modes = Mode.values();
            int index = (this.ordinal() + steps) % modes.length;
            if (index < 0) {
                index += modes.length;
            }
            return modes[index];
        }

        public int getIndex() {
            return this.index;
        }

        private Mode(int index) {
            this.index = index;
        }
    }

    @EventBusSubscriber
    public static class HolyLocketEvents {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get())) {
                int maxDuration;
                MobEffectInstance effect;
                int duration;
                IRelicItem relic;
                Item item = stack.getItem();
                if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).canPlayerUseAbility(player, stack, "ascension") || (duration = (effect = player.getEffect(EffectRegistry.IMMORTALITY)) == null ? 0 : effect.getDuration()) >= (maxDuration = (int)(relic.getStatValue(stack, "ascension", "max_duration") * 20.0))) continue;
                player.addEffect(new MobEffectInstance(EffectRegistry.IMMORTALITY, (int)Math.min(relic.getStatValue(stack, "ascension", "duration") * 20.0 + (double)duration, (double)maxDuration)));
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            Player player;
            ThrowableProjectile essence;
            float amount = event.getAmount();
            if (amount <= 0.5f) {
                return;
            }
            RelicItem item = (RelicItem)ItemRegistry.HOLY_LOCKET.get();
            double maxDistance = item.getRelativeStatValue("faith", "radius", (Double)item.getStatData("faith", "radius").getInitialValue().getValue(), item.getLevelingData().getMaxLevel());
            LivingEntity entity = event.getEntity();
            Level level = entity.getCommandSenderWorld();
            RandomSource random = level.getRandom();
            int targets = 0;
            for (Player player2 : EntityUtils.gatherPotentialTargets((Entity)entity, Player.class, maxDistance).toList()) {
                if (player2.getStringUUID().equals(entity.getStringUUID())) continue;
                ++targets;
                for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player2, (Item)ItemRegistry.HOLY_LOCKET.get())) {
                    HolyLocketItem relic;
                    Item item2 = stack.getItem();
                    if (!(item2 instanceof HolyLocketItem) || (relic = (HolyLocketItem)item2).getMode(stack) != Mode.HOLINESS || !relic.canPlayerUseAbility(player2, stack, "faith") || entity.position().distanceTo(player2.position()) > relic.getStatValue(stack, "faith", "radius")) continue;
                    float heal = (float)((double)amount * relic.getStatValue(stack, "faith", "health"));
                    essence = new LifeEssenceEntity((EntityType<? extends LifeEssenceEntity>)((EntityType)EntityRegistry.LIFE_ESSENCE.get()), level);
                    essence.setHeal(heal);
                    essence.setOwner((Entity)player2);
                    essence.setTarget((LivingEntity)player2);
                    essence.setPos(entity.getEyePosition());
                    essence.setDeltaMovement((double)MathUtils.randomFloat(random), (double)random.nextFloat(), (double)MathUtils.randomFloat(random));
                    level.addFreshEntity((Entity)essence);
                    event.setAmount(amount - heal);
                    relic.spreadRelicExperience((LivingEntity)player2, stack, 1);
                }
                if (targets < 10) continue;
                break;
            }
            if (entity instanceof Player && (player = (Player)entity).getHealth() < player.getMaxHealth()) {
                block2: for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get())) {
                    HolyLocketItem relic;
                    Item item3 = stack.getItem();
                    if (!(item3 instanceof HolyLocketItem) || (relic = (HolyLocketItem)item3).getMode(stack) != Mode.WICKEDNESS || !relic.canPlayerUseAbility(player, stack, "faith")) continue;
                    targets = 0;
                    for (LivingEntity target : EntityUtils.gatherPotentialTargets((Entity)player, LivingEntity.class, relic.getStatValue(stack, "faith", "radius")).toList()) {
                        if (player.getStringUUID().equals(target.getStringUUID())) continue;
                        ++targets;
                        essence = new DeathEssenceEntity((EntityType<? extends DeathEssenceEntity>)((EntityType)EntityRegistry.DEATH_ESSENCE.get()), level);
                        essence.setOwner((Entity)player);
                        essence.setTarget(target);
                        essence.setPos(player.getEyePosition());
                        essence.setDamage((float)((double)event.getAmount() * relic.getStatValue(stack, "faith", "damage")));
                        essence.setDeltaMovement((double)MathUtils.randomFloat(random), (double)random.nextFloat(), (double)MathUtils.randomFloat(random));
                        level.addFreshEntity((Entity)essence);
                        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                        if (targets < 10) continue;
                        continue block2;
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingIncomingDamageEvent event) {
            Object object;
            LivingEntity entity = event.getEntity();
            if (!entity.isInvertedHealAndHarm() || !((object = event.getSource().getEntity()) instanceof Player)) {
                return;
            }
            Player player = (Player)object;
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get())) {
                HolyLocketItem relic;
                Item item = stack.getItem();
                if (!(item instanceof HolyLocketItem) || !(relic = (HolyLocketItem)item).canPlayerUseAbility(player, stack, "penitence")) continue;
                float amount = event.getAmount();
                if (amount >= 1.0f && !entity.isOnFire()) {
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
                event.setAmount((float)((double)amount + (double)amount * relic.getStatValue(stack, "penitence", "amount")));
                entity.igniteForSeconds(10.0f);
            }
        }
    }
}

