/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.common.ContainerSlotClickEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public class AbstractContainerMenuMixin {
    @Inject(at={@At(value="HEAD")}, method={"doClick"}, cancellable=true)
    protected void onClick(int index, int action, ClickType clickType, Player player, CallbackInfo ci) {
        if (clickType != ClickType.PICKUP || index < 0) {
            return;
        }
        AbstractContainerMenu menu = (AbstractContainerMenu)this;
        Slot slot = (Slot)menu.slots.get(index);
        if (this.canInteract(slot, player, menu)) {
            ContainerSlotClickEvent event = new ContainerSlotClickEvent(player, menu, slot, action == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY, menu.getCarried(), slot.getItem());
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                ci.cancel();
            }
        }
    }

    private boolean canInteract(Slot slot, Player player, AbstractContainerMenu menu) {
        ItemStack heldStack = menu.getCarried();
        return !(slot instanceof ResultSlot) && slot.allowModification(player) && menu.canTakeItemForPickAll(heldStack, slot) && slot.isActive();
    }
}

