/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.body;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.network.packets.WingStartFlyPacket;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class WingWildStalkerItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"wings").stat(StatData.builder((String)"strength").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"charges").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.65).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"wings").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-2153433).endColor(8461342).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
            return;
        }
        ItemStack stackFirst = (ItemStack)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).getFirst();
        if (stackFirst.getItem() != stack.getItem()) {
            return;
        }
        if (player.isInLiquid() && player.isFallFlying()) {
            player.stopFallFlying();
        }
        if (player.isFallFlying() && player.tickCount % 20 == 0) {
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
        if (player.getKnownMovement().length() >= 2.0 && player.isFallFlying()) {
            RandomSource random = player.getRandom();
            double width = (double)player.getBbWidth() / 2.0;
            float height = player.getBbHeight();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * width * 2.0;
                double offsetY = random.nextDouble() * (double)height;
                double offsetZ = (random.nextDouble() - 0.5) * width * 2.0;
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(106), random.nextInt(50), random.nextInt(50), random.nextInt(100 + random.nextInt(156))), (float)0.3f, (int)20, (float)0.95f), player.getX() + offsetX, player.getY() - 0.5 + offsetY, player.getZ() + offsetZ, 1, 0.1, 0.1, 0.1, 0.1);
            }
        }
    }

    public int getActualStatValue(ItemStack stack, String stat) {
        return (int)MathUtils.round((double)this.getStatValue(stack, "wings", stat), (int)0);
    }

    public int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharge(ItemStack stack, int charge) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(charge, 0));
    }

    public void consumeCharge(ItemStack stack, int charge) {
        this.setCharge(stack, this.getCharge(stack) - charge);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"back"});
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition back = partdefinition.addOrReplaceChild("back", CubeListBuilder.create(), PartPose.offset((float)11.1726f, (float)-2.4038f, (float)5.2295f));
        PartDefinition cube_r1 = back.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 15).addBox(-2.1367f, -7.2408f, -0.6113f, 2.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0956f, (float)-0.2405f, (float)-0.3988f));
        PartDefinition cube_r2 = back.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(24, 23).addBox(1.0018f, 6.3573f, 6.3213f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0269f, (float)-0.0929f, (float)1.1949f));
        PartDefinition cube_r3 = back.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(24, 15).addBox(4.8646f, -2.3078f, -0.6113f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2579f, (float)0.0168f, (float)-1.6504f));
        PartDefinition cube_r4 = back.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(16, 23).addBox(-2.9741f, -0.7807f, -0.6363f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.9741f, -5.7807f, 0.3887f, 20.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.106f, (float)-0.2362f, (float)0.4108f));
        PartDefinition cube_r5 = back.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(8, 15).addBox(5.7938f, 0.1053f, -0.6113f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2375f, (float)-0.103f, (float)-1.1849f));
        PartDefinition cube_r6 = back.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(16, 15).addBox(1.0018f, 4.3794f, -0.6113f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2416f, (float)-0.0929f, (float)1.1949f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class WingWildStalkerClientEvent {
        @SubscribeEvent
        public static void onClientTick(InputEvent.Key event) {
            WingWildStalkerItem relic;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player == null || minecraft.screen != null || event.getAction() != 1 || event.getKey() != minecraft.options.keyJump.getKey().getValue() || player.isInLiquid() || EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).isEmpty() || player.mayFly()) {
                return;
            }
            ItemStack stackFirst = (ItemStack)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).getFirst();
            Item item = stackFirst.getItem();
            if (!(item instanceof WingWildStalkerItem) || !(relic = (WingWildStalkerItem)item).isAbilityUnlocked(stackFirst, "wings")) {
                return;
            }
            Vec3 deltaMovement = player.getDeltaMovement();
            if (!player.isFallFlying() && !player.onGround()) {
                NetworkHandler.sendToServer((CustomPacketPayload)new WingStartFlyPacket(true));
                player.setDeltaMovement(deltaMovement.add(player.getLookAngle()).add(0.0, 0.6, 0.0));
                player.playSound(SoundEvents.ENDER_DRAGON_FLAP, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            } else if (relic.getCharge(stackFirst) > 0 && player.isFallFlying()) {
                player.setDeltaMovement(player.getDeltaMovement().add(player.getLookAngle().normalize().scale(relic.getStatValue(stackFirst, "wings", "strength") * (double)0.2f)));
                NetworkHandler.sendToServer((CustomPacketPayload)new WingStartFlyPacket(false));
                player.playSound(SoundEvents.ENDER_DRAGON_FLAP, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
        }
    }
}

