/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.ring;

import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

public class ManaRingItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"empower").stat(StatData.builder((String)"capacity").initialValue(50.0, 60.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.233).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"regeneration").initialValue(1.0, 1.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.285).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"empower").initialValue(1).gem(GemShape.SQUARE, GemColor.BLUE).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2251484).borderBottom(-2251484).textured(true).build()).beams(BeamsData.builder().startColor(-1100904).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        if (!this.isAbilityUnlocked(stack, "empower")) {
            return super.getRelicAttributeModifiers(stack);
        }
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier((Holder)PerkAttributes.MAX_MANA, (float)((int)this.getStatValue(stack, "empower", "capacity")), AttributeModifier.Operation.ADD_VALUE)).attribute(new RelicAttributeModifier.Modifier((Holder)PerkAttributes.MANA_REGEN_BONUS, (float)((int)this.getStatValue(stack, "empower", "regeneration")), AttributeModifier.Operation.ADD_VALUE)).build();
    }

    @EventBusSubscriber
    public static class ManaRingEvent {
        @SubscribeEvent
        public static void onCostMana(SpellCostCalcEvent event) {
            ManaRingItem relic;
            Item item;
            IWrappedCaster iWrappedCaster = event.context.getCaster();
            if (!(iWrappedCaster instanceof LivingCaster)) {
                return;
            }
            LivingCaster livingEntity = (LivingCaster)iWrappedCaster;
            LivingEntity entity = livingEntity.livingEntity;
            Level level = entity.getCommandSenderWorld();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.MANA_RING.value()));
            if (level.isClientSide() || !((item = stack.getItem()) instanceof ManaRingItem) || !(relic = (ManaRingItem)item).isAbilityUnlocked(stack, "empower")) {
                return;
            }
            int cost = event.currentCost;
            relic.spreadRelicExperience(entity, stack, cost >= 20 ? cost / 20 : 0);
        }
    }
}

