/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.network.packets;

import io.netty.buffer.ByteBuf;
import it.hurts.octostudios.reliquified_lenders_cataclysm.entities.VoidVortexModifiedEntity;
import java.awt.Color;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record VoidVortexParticlesPacket(int vortexId, int targetId, int particlesID) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, VoidVortexParticlesPacket> STREAM_CODEC = StreamCodec.ofMember(VoidVortexParticlesPacket::encode, VoidVortexParticlesPacket::decode);
    public static final CustomPacketPayload.Type<VoidVortexParticlesPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_lenders_cataclysm", (String)"void_vortex_particles"));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static VoidVortexParticlesPacket decode(ByteBuf buf) {
        return new VoidVortexParticlesPacket(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.vortexId);
        buf.writeInt(this.targetId);
        buf.writeInt(this.particlesID);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Entity patt0$temp;
            Player player = ctx.player();
            Level level = player.getCommandSenderWorld();
            if (!level.isClientSide || !((patt0$temp = level.getEntity(this.vortexId)) instanceof VoidVortexModifiedEntity)) {
                return;
            }
            VoidVortexModifiedEntity vortex = (VoidVortexModifiedEntity)patt0$temp;
            switch (this.particlesID) {
                case 0: {
                    Entity patt1$temp = level.getEntity(this.targetId);
                    if (!(patt1$temp instanceof LivingEntity)) {
                        return;
                    }
                    LivingEntity entity = (LivingEntity)patt1$temp;
                    VoidVortexParticlesPacket.spawnPullParticles(level, (Entity)entity, vortex);
                    break;
                }
                case 1: {
                    VoidVortexParticlesPacket.spawnMergeParticles(level, vortex);
                }
            }
        });
    }

    private static void spawnPullParticles(Level level, Entity entity, VoidVortexModifiedEntity vortex) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isDeadOrDying()) {
            return;
        }
        Vec3 entityPos = entity.position();
        double step = 0.4f;
        if ((double)entity.distanceTo((Entity)vortex) <= 0.5) {
            float radius = 0.5f;
            int particlesNum = (int)(Math.PI * 2 * (double)radius / step);
            double angleIncrement = Math.PI * 2 / (double)particlesNum;
            for (int i = 0; i < particlesNum; ++i) {
                double angle = (double)i * angleIncrement;
                double x = entityPos.x + (double)radius * Math.cos(angle);
                double y = entityPos.y + 0.1 + vortex.randomized(entity.getBoundingBox().getYsize());
                double z = entityPos.z + (double)radius * Math.sin(angle);
                level.addParticle(vortex.getParticle(new Color(105, 0, 229), 0.15f), x, y, z, 0.0, 0.0, 0.0);
            }
        } else {
            Vec3 direction = vortex.position().subtract(entityPos).normalize();
            for (int i = 0; i < 8; ++i) {
                Vec3 pos = entityPos.add(direction.scale((double)i * (step + (double)(0.001f * (float)vortex.getHeight()))));
                double y = pos.y + 0.1;
                float diameterMin = 0.2f;
                if (entity instanceof VoidVortexModifiedEntity) {
                    VoidVortexModifiedEntity voidVortexEntity = (VoidVortexModifiedEntity)entity;
                    y += (double)voidVortexEntity.getHeight() * vortex.randomized(1.0);
                    diameterMin += 0.5f;
                } else {
                    y += vortex.randomized(entity.getBoundingBox().getYsize());
                }
                level.addParticle(vortex.getParticle(new Color(112, 0, 156), diameterMin), pos.x + vortex.randomized(entity.getBoundingBox().getXsize()), y, pos.z + vortex.randomized(entity.getBoundingBox().getZsize()), 0.0, 0.0, 0.0);
            }
        }
    }

    private static void spawnMergeParticles(Level level, VoidVortexModifiedEntity vortex) {
        for (int i = 0; i < vortex.getHeight(); ++i) {
            for (int j = 0; j < 24; ++j) {
                level.addParticle(vortex.getParticle(new Color(61, 0, 135), 0.4f), vortex.getX() + Math.pow(-1.0, i) * vortex.randomized(2.0), vortex.getY() + 0.1 + (double)i + vortex.randomized(0.4), vortex.getZ() + Math.pow(-1.0, i) * vortex.randomized(2.0), 0.0, 0.0, 0.0);
            }
        }
    }
}

