/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.data;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import net.unfamily.repae2bridge.Config;
import org.slf4j.Logger;

public class ReplicationBridgeLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, String> MATTER_DEFINITIONS = new HashMap<String, String>();

    public static void loadConfigFile() {
        if (Config.enableDebugLogging) {
            LOGGER.info("Loading replication bridge matter definitions from config file...");
        }
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            String configFileName = "rep_ae2_bridge_matters.json";
            Path configFilePath = configDir.resolve(configFileName);
            if (Config.enableDebugLogging) {
                LOGGER.info("Attempting to load config file: {}", (Object)configFilePath.toAbsolutePath());
                LOGGER.info("NeoForge config dir: '{}', File name: '{}'", (Object)configDir.toAbsolutePath(), (Object)configFileName);
            }
            MATTER_DEFINITIONS.clear();
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                if (Config.enableDebugLogging) {
                    LOGGER.info("Config file not found: {}. Matter definitions will be empty.", (Object)configFilePath.toAbsolutePath());
                }
                return;
            }
            if (!Files.isRegularFile(configFilePath, new LinkOption[0])) {
                LOGGER.warn("Config file path exists but is not a regular file: {}", (Object)configFilePath);
                return;
            }
            ReplicationBridgeLoader.loadReplicationBridgeFile(configFilePath);
            if (Config.enableDebugLogging) {
                LOGGER.info("Loaded {} replication bridge matter definitions from config file", (Object)MATTER_DEFINITIONS.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading replication bridge config file", (Throwable)e);
        }
    }

    public static void createExampleConfigFile(Path configFilePath) {
        try {
            if (Config.enableDebugLogging) {
                LOGGER.info("Creating example config file at: {}", (Object)configFilePath.toAbsolutePath());
            }
            Files.createDirectories(configFilePath.getParent(), new FileAttribute[0]);
            JsonObject rootObject = new JsonObject();
            rootObject.addProperty("type", "rep_ae2_bridge");
            rootObject.addProperty("overwritable", Boolean.valueOf(true));
            JsonArray entriesArray = new JsonArray();
            List matterTypes = ReplicationRegistry.MATTER_TYPES_REGISTRY.stream().toList();
            Set<IMatterType> builtInMatterTypes = Set.of((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), (IMatterType)ReplicationRegistry.Matter.EARTH.get(), (IMatterType)ReplicationRegistry.Matter.NETHER.get(), (IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), (IMatterType)ReplicationRegistry.Matter.ENDER.get(), (IMatterType)ReplicationRegistry.Matter.METALLIC.get(), (IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), (IMatterType)ReplicationRegistry.Matter.LIVING.get(), (IMatterType)ReplicationRegistry.Matter.QUANTUM.get());
            for (IMatterType matterType : matterTypes) {
                ResourceLocation matterResourceLocation;
                if (builtInMatterTypes.contains(matterType) || (matterResourceLocation = ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)matterType)) == null) continue;
                String matterId = matterResourceLocation.toString();
                JsonObject entryObject = new JsonObject();
                String itemId = matterId.replace(":", "-");
                entryObject.addProperty("itemId", itemId);
                entryObject.addProperty("matterId", matterId);
                entriesArray.add((JsonElement)entryObject);
                if (!Config.enableDebugLogging) continue;
                LOGGER.debug("Created example entry: {} -> {}", (Object)itemId, (Object)matterId);
            }
            rootObject.add("entries", (JsonElement)entriesArray);
            try (BufferedWriter writer = Files.newBufferedWriter(configFilePath, new OpenOption[0]);){
                GSON.toJson((JsonElement)rootObject, (Appendable)writer);
            }
            if (Config.enableDebugLogging) {
                LOGGER.info("Created example config file with {} automatic matter associations", (Object)entriesArray.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create example config file: {}", (Object)configFilePath, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadReplicationBridgeFile(Path filePath) {
        try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject == null) {
                LOGGER.warn("Empty or invalid JSON file: {}", (Object)filePath);
                return;
            }
            if (jsonObject.has("type") && !jsonObject.get("type").getAsString().equals("rep_ae2_bridge")) {
                if (!Config.enableDebugLogging) return;
                LOGGER.warn("Config file has wrong type: expected 'rep_ae2_bridge', found '{}'", (Object)jsonObject.get("type").getAsString());
                return;
            }
            if (jsonObject.has("entries")) {
                JsonArray entriesArray = jsonObject.getAsJsonArray("entries");
                for (JsonElement entryElement : entriesArray) {
                    if (!entryElement.isJsonObject()) continue;
                    JsonObject entryObject = entryElement.getAsJsonObject();
                    if (entryObject.has("itemId") && entryObject.has("matterId")) {
                        String itemId = entryObject.get("itemId").getAsString();
                        String matterId = entryObject.get("matterId").getAsString();
                        String registryName = itemId.replace("-", "_");
                        MATTER_DEFINITIONS.put(registryName, matterId);
                        if (!Config.enableDebugLogging) continue;
                        LOGGER.debug("Loaded replication bridge entry: {} -> {}", (Object)registryName, (Object)matterId);
                        continue;
                    }
                    if (!Config.enableDebugLogging) continue;
                    LOGGER.warn("Invalid entry in config file: missing itemId or matterId");
                }
            }
            if (!Config.enableDebugLogging) return;
            LOGGER.debug("Successfully loaded replication bridge config file: {}", (Object)filePath.getFileName());
            return;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read replication bridge config file: {}", (Object)filePath, (Object)e);
        }
    }

    public static Map<String, String> getMatterDefinitions() {
        return new HashMap<String, String>(MATTER_DEFINITIONS);
    }

    public static String getMatterId(String registryName) {
        return MATTER_DEFINITIONS.get(registryName);
    }
}

