/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.item;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.unfamily.repae2bridge.component.MatterComponent;
import net.unfamily.repae2bridge.component.ModDataComponents;
import net.unfamily.repae2bridge.item.ModItems;
import net.unfamily.repae2bridge.util.MatterTypeInfo;
import net.unfamily.repae2bridge.util.MatterTypeUtil;
import org.slf4j.Logger;

public class UniversalMatterItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public UniversalMatterItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player && !level.isClientSide()) {
            stack.setCount(0);
        }
    }

    public Component getName(ItemStack stack) {
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null) {
            String matterName = component.matterTypeName();
            String capitalizedName = matterName.substring(0, 1).toUpperCase() + matterName.substring(1);
            return Component.literal((String)(capitalizedName + " Matter"));
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MatterTypeInfo info;
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null && (info = MatterTypeUtil.getMatterInfo(component.matterTypeName())) != null && !info.registryId().getNamespace().equals("replication")) {
            tooltipComponents.add((Component)Component.literal((String)("From: " + info.registryId().getNamespace())).withStyle(ChatFormatting.GRAY));
        }
        tooltipComponents.add((Component)Component.translatable((String)"item.rep_ae2_bridge.universal_matter.warning").withStyle(ChatFormatting.RED));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public String getDescriptionId(ItemStack stack) {
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null) {
            return "item.rep_ae2_bridge.universal_matter." + component.matterTypeName().toLowerCase().replace(" ", "_");
        }
        return super.getDescriptionId(stack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public static ItemStack createMatterStack(IMatterType matterType, int count) {
        ResourceLocation registryId;
        MatterTypeInfo info = MatterTypeUtil.getMatterInfo(matterType);
        String name = matterType.getName();
        float[] color = (float[])matterType.getColor().get();
        ResourceLocation texture = info != null ? info.texture() : ((registryId = ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)matterType)) != null ? ResourceLocation.fromNamespaceAndPath((String)registryId.getNamespace(), (String)("gui/mattertypes/" + name.toLowerCase())) : ResourceLocation.fromNamespaceAndPath((String)"replication", (String)("gui/mattertypes/" + name.toLowerCase())));
        ItemStack stack = new ItemStack((ItemLike)ModItems.UNIVERSAL_MATTER.get(), count);
        MatterComponent component = new MatterComponent(name, texture, color);
        stack.set((DataComponentType)ModDataComponents.MATTER.get(), (Object)component);
        MatterComponent verifyComponent = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (verifyComponent == null) {
            // empty if block
        }
        return stack;
    }
}

