/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.custom;

import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RepRS2BridgeBlock
extends BasicTileBlock<RepRS2BridgeBlockEntity>
implements INetworkDirectionalConnection {
    public static final VoxelShape SHAPE = RepRS2BridgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final MapCodec<RepRS2BridgeBlock> CODEC = RepRS2BridgeBlock.simpleCodec(RepRS2BridgeBlock::new);
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");

    public RepRS2BridgeBlock(BlockBehaviour.Properties properties) {
        super(properties, RepRS2BridgeBlockEntity.class);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BasicTileBlock<RepRS2BridgeBlockEntity>> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return RepRS2BridgeBlockEntity::new;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof RepRS2BridgeBlockEntity) {
            RepRS2BridgeBlockEntity blockEntity2 = (RepRS2BridgeBlockEntity)blockEntity;
            blockEntity2.handleNeighborChanged(pos);
            blockEntity2.updateConnectedState();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof RepRS2BridgeBlockEntity) {
            RepRS2BridgeBlockEntity blockEntity2 = (RepRS2BridgeBlockEntity)blockEntity;
            blockEntity2.handleNeighborChanged(fromPos);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof RepRS2BridgeBlockEntity) {
            RepRS2BridgeBlockEntity blockEntity2 = (RepRS2BridgeBlockEntity)blockEntity;
            this.dropInventory(level, pos, blockEntity2);
        }
        super.onRemove(state, level, pos, newState, moving);
        if (!state.is(newState.getBlock()) && !level.isClientSide()) {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                level.updateNeighborsAt(neighborPos, (Block)this);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && !player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof RepRS2BridgeBlockEntity) {
            RepRS2BridgeBlockEntity bridge = (RepRS2BridgeBlockEntity)blockEntity;
            boolean connectedToReplication = false;
            try {
                connectedToReplication = bridge.getNetwork() != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!connectedToReplication) {
                ItemStack drop = new ItemStack((ItemLike)this);
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)drop);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        block3: {
            super.tick(state, level, pos, random);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof RepRS2BridgeBlockEntity) {
                RepRS2BridgeBlockEntity blockEntity2 = (RepRS2BridgeBlockEntity)blockEntity;
                try {
                    blockEntity2.onLoad();
                }
                catch (RuntimeException e) {
                    if (e.getMessage() == null || !e.getMessage().contains("network is null")) break block3;
                    level.scheduleTick(pos, (Block)this, 20);
                }
            }
        }
    }

    private void dropInventory(Level level, BlockPos pos, RepRS2BridgeBlockEntity blockEntity) {
        InventoryComponent<RepRS2BridgeBlockEntity> inventory = blockEntity.getOutput();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack.copy());
            stack.setCount(0);
        }
    }
}

