/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity;

import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.leclowndu93150.replication_rs2_bridge.block.ModBlocks;
import com.leclowndu93150.replication_rs2_bridge.block.custom.RepRS2BridgeBlock;
import com.leclowndu93150.replication_rs2_bridge.block.entity.ModBlockEntities;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeNetworkNode;
import com.leclowndu93150.replication_rs2_bridge.block.entity.lifecycle.Rs2NodeLifecycle;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.PatternSignature;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.ReplicationPatternTemplate;
import com.leclowndu93150.replication_rs2_bridge.block.entity.storage.MatterItemsStorage;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.ReplicationTaskHandler;
import com.leclowndu93150.replication_rs2_bridge.block.entity.task.TaskSnapshotNbt;
import com.leclowndu93150.replication_rs2_bridge.item.ModItems;
import com.leclowndu93150.replication_rs2_bridge.menu.RepRS2BridgeData;
import com.leclowndu93150.replication_rs2_bridge.menu.RepRS2BridgeMenu;
import com.leclowndu93150.replication_rs2_bridge.storage.BridgePatternRepository;
import com.leclowndu93150.replication_rs2_bridge.storage.BridgePatternStorage;
import com.leclowndu93150.replication_rs2_bridge.storage.BridgeTaskSnapshotRepository;
import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RepRS2BridgeBlockEntity
extends ReplicationMachine<RepRS2BridgeBlockEntity>
implements ConfigurationCardTarget,
ExtendedMenuProvider<RepRS2BridgeData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INITIALIZATION_DELAY = 60;
    private static final int PATTERN_UPDATE_INTERVAL = 100;
    private static final String TAG_RS_TASK_SNAPSHOTS = "RsTaskSnapshots";
    private static final String TAG_PATTERN_ID_MAPPINGS = "PatternIdMappings";
    private static final String TAG_PATTERN_ID = "PatternId";
    private static final String TAG_PRIORITY = "Priority";
    private byte initialized = 0;
    private int initializationTicks = 0;
    private int patternUpdateTicks = 0;
    private int debugTickCounter = 0;
    @Save
    private InventoryComponent<RepRS2BridgeBlockEntity> output;
    @Save
    private UUID blockId = UUID.randomUUID();
    @Save
    private int priority = 0;
    private final RepRS2BridgeNetworkNode networkNode;
    private final InWorldNetworkNodeContainer nodeContainer;
    private final NetworkNodeContainerProvider containerProvider;
    private final Rs2NodeLifecycle nodeLifecycle;
    private final MatterItemsStorage matterItemsStorage;
    private static final int TASK_SNAPSHOT_SAVE_INTERVAL = 20;
    private int taskSnapshotSaveTicks = 0;
    private boolean hadActiveRsTasks = false;
    private static boolean worldUnloading = false;
    private static final Set<RepRS2BridgeBlockEntity> activeBridges = new HashSet<RepRS2BridgeBlockEntity>();
    private CompoundTag pendingMigrationTag = null;
    private final ReplicationTaskHandler taskHandler;

    public RepRS2BridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BasicTileBlock)ModBlocks.REP_RS2_BRIDGE.get(), (BlockEntityType)ModBlockEntities.REP_RS2_BRIDGE.get(), pos, state);
        this.output = new InventoryComponent("output", 11, 131, 18).setRange(9, 2).setComponentHarness((IComponentHarness)this).setInputFilter((stack, slot) -> true);
        this.addInventory(this.output);
        this.networkNode = new RepRS2BridgeNetworkNode(this, 10L);
        this.containerProvider = RefinedStorageApi.INSTANCE.createNetworkNodeContainerProvider();
        this.nodeContainer = RefinedStorageApi.INSTANCE.createNetworkNodeContainer((BlockEntity)this, (NetworkNode)this.networkNode).connectionStrategy((ConnectionStrategy)new ColoredConnectionStrategy(() -> ((RepRS2BridgeBlockEntity)this).getBlockState(), this.worldPosition)).build();
        this.containerProvider.addContainer(this.nodeContainer);
        this.nodeLifecycle = new Rs2NodeLifecycle(this, this.containerProvider, LOGGER);
        this.taskHandler = new ReplicationTaskHandler(this);
        this.matterItemsStorage = new MatterItemsStorage(this, this.taskHandler);
        this.initialized = 0;
        this.initializationTicks = 0;
        activeBridges.add(this);
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.level != null && !this.level.isClientSide()) {
            this.nodeLifecycle.requestInitialization("clear_removed");
        }
    }

    @NotNull
    public RepRS2BridgeBlockEntity getSelf() {
        return this;
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        try {
            return new DefaultMatterNetworkElement(this, level, pos){

                public boolean canConnectFrom(Direction direction) {
                    BlockPos neighborPos = this.pos.relative(direction);
                    if (this.level.getBlockEntity(neighborPos) instanceof RepRS2BridgeBlockEntity) {
                        return false;
                    }
                    return super.canConnectFrom(direction);
                }
            };
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Replication network element: {}", (Object)e.getMessage());
            return null;
        }
    }

    public NetworkElement createReplicationNetworkElement() {
        if (this.level == null) {
            return null;
        }
        return this.createElement(this.level, this.worldPosition);
    }

    public void onLoad() {
        try {
            super.onLoad();
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().contains("network is null")) {
                LOGGER.warn("Bridge: Replication network not ready during onLoad, will retry later");
                if (this.level != null && !this.level.isClientSide()) {
                    this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 60);
                }
                return;
            }
            LOGGER.error("Bridge: Unexpected error during onLoad: {}", (Object)e.getMessage());
            if (this.level != null && !this.level.isClientSide()) {
                this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 100);
            }
            return;
        }
        if (this.level != null && !this.level.isClientSide()) {
            this.migrateOldPatternMappings();
            this.taskHandler.loadFromRepository();
            this.nodeLifecycle.requestInitialization("on_load");
        }
    }

    public void handleNeighborChanged(BlockPos fromPos) {
        if (this.level != null && !this.level.isClientSide()) {
            Direction directionToNeighbor = null;
            for (Direction dir : Direction.values()) {
                if (!this.worldPosition.relative(dir).equals((Object)fromPos)) continue;
                directionToNeighbor = dir;
                break;
            }
            if (directionToNeighbor != null && this.level.getBlockEntity(fromPos) instanceof RepRS2BridgeBlockEntity) {
                return;
            }
            this.nodeLifecycle.requestInitialization("neighbor_change");
            this.updateConnectedState();
        }
    }

    public void onRsNodeInitializedFromLifecycle() {
        this.updateConnectedState();
        this.forceNeighborUpdates();
        this.matterItemsStorage.refreshCache();
        this.networkNode.setPriority(this.priority);
        this.patternUpdateTicks = 100;
        try {
            this.updateRS2Patterns(this.getNetwork());
        }
        catch (Exception patternEx) {
            LOGGER.error("Bridge: Pattern update failed during initialization", (Throwable)patternEx);
        }
    }

    public void updateConnectedState() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock() instanceof RepRS2BridgeBlock && state.hasProperty((Property)RepRS2BridgeBlock.CONNECTED)) {
            boolean connected;
            boolean bl = connected = this.isActive() && this.getNetwork() != null;
            if ((Boolean)state.getValue((Property)RepRS2BridgeBlock.CONNECTED) != connected) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)RepRS2BridgeBlock.CONNECTED, (Comparable)Boolean.valueOf(connected)), 3);
            }
        }
    }

    private void forceNeighborUpdates() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = this.worldPosition.relative(direction);
            BlockState neighborState = this.level.getBlockState(neighborPos);
            this.level.neighborChanged(neighborPos, state.getBlock(), this.worldPosition);
            if (!(neighborState.getBlock() instanceof MatterPipeBlock)) continue;
            this.level.sendBlockUpdated(neighborPos, neighborState, neighborState, 3);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, RepRS2BridgeBlockEntity blockEntity) {
        NetworkManager networkManager;
        if (worldUnloading) {
            return;
        }
        try {
            super.serverTick(level, pos, state, (NetworkBlockEntity)blockEntity);
        }
        catch (Exception e) {
            LOGGER.error("Bridge: Exception in super.serverTick(): {}", (Object)e.getMessage());
            return;
        }
        if (worldUnloading) {
            return;
        }
        this.nodeLifecycle.tick();
        MatterNetwork replicationNetwork = this.getNetwork();
        this.taskHandler.tick(replicationNetwork);
        if (this.initialized == 0) {
            ++this.initializationTicks;
            if (this.initializationTicks >= 60) {
                this.initialized = 1;
            }
        }
        if (level.getGameTime() % 20L == 0L) {
            if (this.initialized == 1) {
                try {
                    this.transferItemsToRS2();
                }
                catch (Exception e) {
                    LOGGER.error("Bridge: Exception in transferItemsToRS2(): {}", (Object)e.getMessage());
                }
            }
            this.matterItemsStorage.refreshCache();
        }
        if (level.getGameTime() % 6000L == 0L && this.initialized == 1) {
            this.saveTaskSnapshotsToRepository();
            this.taskHandler.saveToRepository();
        }
        if (this.patternUpdateTicks >= 100) {
            boolean updated = false;
            if (this.isActive() && replicationNetwork != null) {
                try {
                    this.updateRS2Patterns(replicationNetwork);
                    updated = true;
                }
                catch (Exception e) {
                    LOGGER.error("Bridge: Exception during pattern update: {}", (Object)e.getMessage());
                }
            }
            this.patternUpdateTicks = updated ? 0 : 100;
        } else {
            ++this.patternUpdateTicks;
        }
        if (replicationNetwork == null && (networkManager = NetworkManager.get((Level)level)) != null && networkManager.getElement(pos) == null) {
            networkManager.addElement(this.createElement(level, pos));
        }
        this.updateConnectedState();
        this.tickNetworkNode();
        this.tickTaskSnapshotPersistence();
    }

    private void updateRS2Patterns(@Nullable MatterNetwork replicationNetwork) {
        if (!this.isActive() || this.networkNode == null || replicationNetwork == null || this.level == null) {
            return;
        }
        List<ReplicationPatternTemplate> templates = this.collectReplicationTemplates(replicationNetwork);
        BridgePatternRepository repo = BridgePatternStorage.get(this.level);
        Map<PatternSignature, UUID> patternIds = repo.getPatternsForBridge(this.blockId);
        if (templates.isEmpty()) {
            if (!patternIds.isEmpty()) {
                patternIds.clear();
                repo.setDirty();
            }
        } else {
            Set currentSignatures = templates.stream().map(ReplicationPatternTemplate::signature).collect(Collectors.toSet());
            if (patternIds.keySet().retainAll(currentSignatures)) {
                repo.setDirty();
            }
        }
        this.networkNode.updatePatterns(templates);
    }

    private void transferItemsToRS2() {
        if (this.networkNode == null || this.networkNode.getNetwork() == null) {
            return;
        }
        Network network = this.networkNode.getNetwork();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        if (storage == null) {
            return;
        }
        boolean itemsMoved = false;
        for (int i = 0; i < this.output.getSlots(); ++i) {
            ItemResource resource;
            long inserted;
            ItemStack stack = this.output.getStackInSlot(i);
            if (stack.isEmpty() || (inserted = storage.insert((ResourceKey)(resource = ItemResource.ofItemStack((ItemStack)stack)), (long)stack.getCount(), Action.EXECUTE, Actor.EMPTY)) <= 0L) continue;
            stack.shrink((int)inserted);
            itemsMoved = true;
        }
        if (itemsMoved) {
            this.setChanged();
        }
    }

    public boolean receiveItemFromReplicator(ItemStack stack) {
        ItemResource resource;
        long inserted;
        Network network;
        StorageNetworkComponent storage;
        if (stack.isEmpty()) {
            return false;
        }
        boolean insertedIntoRS2 = false;
        long remainingCount = stack.getCount();
        if (this.networkNode != null && this.networkNode.getNetwork() != null && (storage = (StorageNetworkComponent)(network = this.networkNode.getNetwork()).getComponent(StorageNetworkComponent.class)) != null && (inserted = storage.insert((ResourceKey)(resource = ItemResource.ofItemStack((ItemStack)stack)), (long)stack.getCount(), Action.EXECUTE, Actor.EMPTY)) > 0L) {
            for (int i = 0; i < this.output.getSlots(); ++i) {
                ItemStack slotStack = this.output.getStackInSlot(i);
                if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)stack)) continue;
                int toRemove = (int)Math.min(inserted, (long)slotStack.getCount());
                slotStack.shrink(toRemove);
                if ((inserted -= (long)toRemove) <= 0L) break;
            }
            insertedIntoRS2 = true;
            if ((remainingCount -= inserted) <= 0L) {
                return true;
            }
        }
        if (remainingCount > 0L) {
            ItemStack remainingStack = stack.copy();
            remainingStack.setCount((int)remainingCount);
            ItemStack notInserted = ItemHandlerHelper.insertItem(this.output, (ItemStack)remainingStack, (boolean)false);
            if (notInserted.isEmpty()) {
                this.setChanged();
                return true;
            }
            if ((long)notInserted.getCount() < remainingCount) {
                this.setChanged();
                return insertedIntoRS2 || notInserted.getCount() < stack.getCount();
            }
            return insertedIntoRS2;
        }
        return true;
    }

    private boolean hasRequiredMatter(ReplicationPatternTemplate template) {
        MatterNetwork network = this.getNetwork();
        if (network == null) {
            return false;
        }
        for (Map.Entry<IMatterType, Long> entry : template.matterCost().entrySet()) {
            long available = network.calculateMatterAmount(entry.getKey());
            if (available >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private List<ReplicationPatternTemplate> collectReplicationTemplates(MatterNetwork network) {
        if (this.level == null || this.level.isClientSide()) {
            return List.of();
        }
        ArrayList<ReplicationPatternTemplate> templates = new ArrayList<ReplicationPatternTemplate>();
        for (NetworkElement element : network.getChipSuppliers()) {
            BlockEntity tile = element.getLevel().getBlockEntity(element.getPos());
            if (!(tile instanceof ChipStorageBlockEntity)) continue;
            ChipStorageBlockEntity chipStorage = (ChipStorageBlockEntity)tile;
            for (MatterPattern pattern : chipStorage.getPatterns(this.level, chipStorage)) {
                Map<IMatterType, Long> cost;
                if (pattern.getStack().isEmpty() || pattern.getCompletion() != 1.0f || (cost = this.calculateMatterCost(pattern.getStack())).isEmpty()) continue;
                ItemStack output = pattern.getStack().copy();
                PatternSignature signature = PatternSignature.from(output, cost);
                templates.add(new ReplicationPatternTemplate(signature, output, pattern, cost));
            }
        }
        return templates;
    }

    private Map<IMatterType, Long> calculateMatterCost(ItemStack stack) {
        HashMap<IMatterType, Long> cost = new HashMap<IMatterType, Long>();
        MatterCompound compound = ReplicationCalculation.getMatterCompound((ItemStack)stack);
        if (compound == null) {
            return cost;
        }
        for (MatterValue value : compound.getValues().values()) {
            long amount;
            IMatterType matterType = value.getMatter();
            if (matterType == null || (amount = (long)Math.ceil(value.getAmount())) <= 0L) continue;
            cost.merge(matterType, amount, Long::sum);
        }
        return cost;
    }

    public ExternalPatternSink.Result handlePatternRequest(ReplicationPatternTemplate template, Collection<ResourceAmount> resources, Action action) {
        if (template == null || worldUnloading || this.initialized != 1) {
            return ExternalPatternSink.Result.REJECTED;
        }
        if (!this.hasRequiredMatter(template)) {
            return ExternalPatternSink.Result.REJECTED;
        }
        if (action == Action.SIMULATE) {
            return ExternalPatternSink.Result.ACCEPTED;
        }
        this.taskHandler.queuePatternRequest(template);
        return ExternalPatternSink.Result.ACCEPTED;
    }

    public MatterNetwork getNetwork() {
        if (this.level == null || this.level.isClientSide()) {
            return null;
        }
        if (worldUnloading) {
            return null;
        }
        try {
            com.hrznstudio.titanium.block_network.Network network;
            NetworkManager networkManager = NetworkManager.get((Level)this.level);
            if (networkManager == null) {
                return null;
            }
            NetworkElement element = networkManager.getElement(this.worldPosition);
            if (element == null) {
                if (worldUnloading) {
                    return null;
                }
                element = this.createElement(this.level, this.worldPosition);
                if (element != null) {
                    networkManager.addElement(element);
                }
            }
            if (element != null && (network = element.getNetwork()) instanceof MatterNetwork) {
                MatterNetwork matterNetwork = (MatterNetwork)network;
                return matterNetwork;
            }
        }
        catch (Exception e) {
            LOGGER.error("Bridge: Exception accessing Replication network: {}", (Object)e.getMessage());
        }
        return null;
    }

    public boolean isActive() {
        if (worldUnloading) {
            return false;
        }
        try {
            return this.networkNode != null && this.networkNode.isActive() && this.networkNode.getNetwork() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBridgeInitialized() {
        return this.initialized == 1;
    }

    public void onNetworkActivityChanged(boolean active) {
        this.updateConnectedState();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.blockId != null) {
            tag.putUUID("BlockId", this.blockId);
        }
        tag.putInt(TAG_PRIORITY, this.priority);
        this.taskHandler.saveLocalRequestState(tag, registries);
        this.taskHandler.saveLocalActiveTasks(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        System.out.println(tag);
        this.blockId = tag.contains("BlockId") ? tag.getUUID("BlockId") : UUID.randomUUID();
        if (tag.contains(TAG_PRIORITY)) {
            this.priority = tag.getInt(TAG_PRIORITY);
        }
        this.nodeLifecycle.resetAfterDataLoad();
        this.taskHandler.loadLocalRequestState(tag, registries);
        this.taskHandler.loadLocalActiveTasks(tag, registries);
        this.loadTaskSnapshotsFromRepository();
        if (tag.contains(TAG_RS_TASK_SNAPSHOTS, 9)) {
            this.loadTaskSnapshots(tag, registries);
        }
        if (tag.contains(TAG_PATTERN_ID_MAPPINGS, 9)) {
            this.pendingMigrationTag = tag.copy();
        }
        this.taskHandler.resetAfterDataLoad();
    }

    public void setRemoved() {
        activeBridges.remove((Object)this);
        this.saveTaskSnapshotsToRepository();
        this.taskHandler.saveToRepository();
        if (!this.nodeLifecycle.isRemoved()) {
            this.nodeLifecycle.shutdown("set_removed", false);
        }
        super.setRemoved();
    }

    public void onChunkUnloaded() {
        this.saveTaskSnapshotsToRepository();
        this.taskHandler.saveToRepository();
        if (!this.nodeLifecycle.isRemoved()) {
            this.nodeLifecycle.shutdown("chunk_unloaded", true);
        }
        super.onChunkUnloaded();
    }

    public void disconnectFromNetworks() {
        if (!this.nodeLifecycle.isRemoved()) {
            this.nodeLifecycle.shutdown("manual_disconnect", false);
        }
        this.initialized = 0;
        this.initializationTicks = 0;
    }

    public static void setWorldUnloading(boolean unloading) {
        if (unloading && !worldUnloading) {
            LOGGER.info("RepRS2Bridge: World unloading detected - All bridges will now shutdown");
            RepRS2BridgeBlockEntity.cancelAllPendingOperations();
            RepRS2BridgeBlockEntity.disconnectAllBridgesFromNetworks();
        }
        worldUnloading = unloading;
    }

    public static boolean isWorldUnloading() {
        return worldUnloading;
    }

    private static void cancelAllPendingOperations() {
        for (RepRS2BridgeBlockEntity bridge : new ArrayList<RepRS2BridgeBlockEntity>(activeBridges)) {
            bridge.taskHandler.clearPendingOperations();
        }
    }

    private static void disconnectAllBridgesFromNetworks() {
        ArrayList<RepRS2BridgeBlockEntity> bridgesToDisconnect = new ArrayList<RepRS2BridgeBlockEntity>(activeBridges);
        for (RepRS2BridgeBlockEntity bridge : bridgesToDisconnect) {
            try {
                bridge.disconnectFromNetworks();
            }
            catch (Exception e) {
                LOGGER.warn("RepRS2Bridge: Failed to disconnect bridge: {}", (Object)e.getMessage());
            }
        }
        activeBridges.clear();
    }

    Item getItemForMatterType(IMatterType type) {
        return (Item)ModItems.UNIVERSAL_MATTER.get();
    }

    private boolean isVirtualMatterItem(Item item) {
        return item == ModItems.UNIVERSAL_MATTER.get();
    }

    public InventoryComponent<RepRS2BridgeBlockEntity> getOutput() {
        return this.output;
    }

    public MatterItemsStorage getMatterStorage() {
        return this.matterItemsStorage;
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (this.level != null && !this.level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)this, this.worldPosition);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.replication_rs2_bridge.rep_rs2_bridge");
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new RepRS2BridgeMenu(syncId, playerInventory, this);
    }

    public RepRS2BridgeData getMenuData() {
        return new RepRS2BridgeData();
    }

    public StreamEncoder<RegistryFriendlyByteBuf, RepRS2BridgeData> getMenuCodec() {
        return RepRS2BridgeData.STREAM_CODEC;
    }

    public UUID getBlockId() {
        return this.blockId;
    }

    public NetworkNode getNetworkNode() {
        return this.networkNode;
    }

    public RepRS2BridgeNetworkNode getBridgeNetworkNode() {
        return this.networkNode;
    }

    public void handleExternalIteration() {
        this.debugTickCounter = 0;
    }

    public void cancelReplicationTaskForRS2Task(TaskId rs2TaskId) {
        this.taskHandler.cancelReplicationTaskForRs2Task(rs2TaskId);
    }

    private void tickNetworkNode() {
        boolean hasEnergy;
        Network network = this.networkNode.getNetwork();
        if (network == null || worldUnloading) {
            if (this.networkNode.isActive()) {
                this.networkNode.setActive(false);
            }
            return;
        }
        EnergyNetworkComponent energy = (EnergyNetworkComponent)network.getComponent(EnergyNetworkComponent.class);
        boolean shouldBeActive = hasEnergy = energy == null || energy.getStored() >= this.networkNode.getEnergyUsage();
        if (this.networkNode.isActive() != shouldBeActive) {
            this.networkNode.setActive(shouldBeActive);
        }
        if (shouldBeActive) {
            this.networkNode.doWork();
        }
    }

    private void tickTaskSnapshotPersistence() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        boolean hasTasks = this.networkNode.hasActiveTasks();
        if (hasTasks) {
            if (!this.hadActiveRsTasks) {
                this.markTaskSnapshotsDirty();
            } else if (++this.taskSnapshotSaveTicks >= 20) {
                this.markTaskSnapshotsDirty();
            }
        } else if (this.hadActiveRsTasks) {
            this.markTaskSnapshotsDirty();
        } else {
            this.taskSnapshotSaveTicks = 0;
        }
        this.hadActiveRsTasks = hasTasks;
    }

    private void markTaskSnapshotsDirty() {
        this.taskSnapshotSaveTicks = 0;
        this.saveTaskSnapshotsToRepository();
        this.setChanged();
    }

    public NetworkNodeContainerProvider getContainerProvider() {
        return this.containerProvider;
    }

    UUID getOrCreatePatternId(PatternSignature signature) {
        if (this.level == null) {
            return UUID.randomUUID();
        }
        BridgePatternRepository repo = BridgePatternStorage.get(this.level);
        Map<PatternSignature, UUID> patterns = repo.getPatternsForBridge(this.blockId);
        UUID existing = patterns.get(signature);
        if (existing != null) {
            return existing;
        }
        UUID newId = UUID.randomUUID();
        patterns.put(signature, newId);
        repo.setDirty();
        return newId;
    }

    private void migrateOldPatternMappings() {
        if (this.pendingMigrationTag == null || this.level == null) {
            return;
        }
        HashMap<PatternSignature, UUID> oldPatterns = new HashMap<PatternSignature, UUID>();
        ListTag list = this.pendingMigrationTag.getList(TAG_PATTERN_ID_MAPPINGS, 10);
        for (Tag element : list) {
            CompoundTag entry = (CompoundTag)element;
            UUID patternId = entry.getUUID(TAG_PATTERN_ID);
            oldPatterns.put(PatternSignature.load(entry), patternId);
        }
        if (!oldPatterns.isEmpty()) {
            BridgePatternRepository repo = BridgePatternStorage.get(this.level);
            repo.setPatternsForBridge(this.blockId, oldPatterns);
            LOGGER.info("Migrated {} pattern mappings for bridge {}", (Object)oldPatterns.size(), (Object)this.blockId);
        }
        this.pendingMigrationTag = null;
    }

    private void saveTaskSnapshotsToRepository() {
        if (this.level == null || this.level.isClientSide() || this.blockId == null) {
            return;
        }
        List<TaskSnapshot> snapshots = this.networkNode.getTaskSnapshots();
        BridgeTaskSnapshotRepository repo = BridgePatternStorage.getTaskSnapshots(this.level);
        repo.setSnapshotsForBridge(this.blockId, snapshots);
    }

    private void loadTaskSnapshotsFromRepository() {
        if (this.level == null || this.level.isClientSide() || this.blockId == null) {
            return;
        }
        BridgeTaskSnapshotRepository repo = BridgePatternStorage.getTaskSnapshots(this.level);
        List<TaskSnapshot> snapshots = repo.getSnapshotsForBridge(this.blockId);
        if (!snapshots.isEmpty()) {
            this.networkNode.restoreTasks(snapshots);
        }
    }

    private void loadTaskSnapshots(CompoundTag tag, HolderLookup.Provider registries) {
        if (!tag.contains(TAG_RS_TASK_SNAPSHOTS, 9)) {
            return;
        }
        ArrayList<TaskSnapshot> snapshots = new ArrayList<TaskSnapshot>();
        for (Tag element : tag.getList(TAG_RS_TASK_SNAPSHOTS, 10)) {
            try {
                snapshots.add(TaskSnapshotNbt.decode((CompoundTag)element));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to decode legacy task snapshot: {}", (Object)e.getMessage());
            }
        }
        if (!snapshots.isEmpty()) {
            this.networkNode.restoreTasks(snapshots);
            if (this.level != null && !this.level.isClientSide() && this.blockId != null) {
                BridgeTaskSnapshotRepository repo = BridgePatternStorage.getTaskSnapshots(this.level);
                repo.setSnapshotsForBridge(this.blockId, snapshots);
                LOGGER.info("Migrated {} task snapshots from NBT to SavedData for bridge {}", (Object)snapshots.size(), (Object)this.blockId);
            }
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (this.priority != priority) {
            this.priority = priority;
            if (this.networkNode != null) {
                this.networkNode.setPriority(priority);
            }
            this.setChanged();
        }
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt(TAG_PRIORITY, this.priority);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_PRIORITY)) {
            this.setPriority(tag.getInt(TAG_PRIORITY));
        }
    }
}

