/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity;

import com.buuz135.replication.api.IMatterType;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.PatternSignature;
import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.ReplicationPatternTemplate;
import com.leclowndu93150.replication_rs2_bridge.item.UniversalMatterItem;
import com.mojang.logging.LogUtils;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TaskContainer;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageProvider;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class RepRS2BridgeNetworkNode
extends AbstractNetworkNode
implements StorageProvider,
PatternProvider,
TaskListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RepRS2BridgeBlockEntity blockEntity;
    private final long energyUsage;
    private final TaskContainer tasks = new TaskContainer((PatternProvider)this);
    private final Set<ParentContainer> parents = new HashSet<ParentContainer>();
    private final Map<PatternSignature, ReplicationPatternInstance> patternsBySignature = new HashMap<PatternSignature, ReplicationPatternInstance>();
    private final Map<Pattern, ReplicationPatternInstance> patternsByPattern = new HashMap<Pattern, ReplicationPatternInstance>();
    private final List<TaskSnapshot> deferredSnapshots = new ArrayList<TaskSnapshot>();
    private StepBehavior stepBehavior = StepBehavior.DEFAULT;
    private int priority;

    public RepRS2BridgeNetworkNode(RepRS2BridgeBlockEntity blockEntity, long energyUsage) {
        this.blockEntity = blockEntity;
        this.energyUsage = energyUsage;
    }

    public long getEnergyUsage() {
        return this.energyUsage;
    }

    public void setNetwork(@Nullable Network newNetwork) {
        StorageNetworkComponent storage;
        Network previous = this.network;
        if (previous != null && previous != newNetwork) {
            this.tasks.detachAll(previous);
            storage = (StorageNetworkComponent)previous.getComponent(StorageNetworkComponent.class);
            if (storage != null) {
                storage.removeSource(this.getStorage());
            }
        }
        super.setNetwork(newNetwork);
        if (newNetwork != null) {
            this.tasks.attachAll(newNetwork);
            if (this.isActive() && (storage = (StorageNetworkComponent)newNetwork.getComponent(StorageNetworkComponent.class)) != null) {
                storage.addSource(this.getStorage());
            }
            this.rebuildDeferredTasks();
        }
    }

    public void doWork() {
        super.doWork();
        if (this.network != null) {
            this.tasks.step(this.network, this.stepBehavior, (TaskListener)this);
        }
    }

    protected void onActiveChanged(boolean newActive) {
        StorageNetworkComponent storage;
        super.onActiveChanged(newActive);
        if (this.network != null && (storage = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class)) != null) {
            if (newActive) {
                storage.addSource(this.getStorage());
            } else {
                storage.removeSource(this.getStorage());
            }
        }
        this.blockEntity.onNetworkActivityChanged(newActive);
    }

    public Storage getStorage() {
        return this.blockEntity.getMatterStorage();
    }

    public boolean hasActiveTasks() {
        return !this.tasks.getAll().isEmpty();
    }

    public void setPriority(int priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
        this.parents.forEach(parent -> this.patternsByPattern.keySet().forEach(pattern -> parent.update(pattern, priority)));
    }

    public void setStepBehavior(StepBehavior behavior) {
        this.stepBehavior = behavior;
    }

    public void refreshStorageInNetwork() {
        if (this.network == null || !this.isActive()) {
            return;
        }
        StorageNetworkComponent storage = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
        if (storage != null) {
            storage.removeSource(this.getStorage());
            storage.addSource(this.getStorage());
        }
    }

    public void updatePatterns(List<ReplicationPatternTemplate> templates) {
        HashMap<PatternSignature, ReplicationPatternInstance> nextBySignature = new HashMap<PatternSignature, ReplicationPatternInstance>();
        HashMap<Pattern, ReplicationPatternInstance> nextByPattern = new HashMap<Pattern, ReplicationPatternInstance>();
        ArrayList<Pattern> added = new ArrayList<Pattern>();
        ArrayList<Pattern> removed = new ArrayList<Pattern>();
        for (ReplicationPatternTemplate template : templates) {
            ReplicationPatternInstance existing = this.patternsBySignature.get(template.signature());
            if (existing != null) {
                ReplicationPatternInstance updated = new ReplicationPatternInstance(existing.pattern(), template);
                nextBySignature.put(template.signature(), updated);
                nextByPattern.put(existing.pattern(), updated);
                continue;
            }
            Pattern pattern2 = this.createPattern(template);
            if (pattern2 == null) continue;
            ReplicationPatternInstance instance = new ReplicationPatternInstance(pattern2, template);
            nextBySignature.put(template.signature(), instance);
            nextByPattern.put(pattern2, instance);
            added.add(pattern2);
        }
        for (Pattern pattern3 : this.patternsByPattern.keySet()) {
            if (nextByPattern.containsKey(pattern3)) continue;
            removed.add(pattern3);
        }
        this.patternsBySignature.clear();
        this.patternsBySignature.putAll(nextBySignature);
        this.patternsByPattern.clear();
        this.patternsByPattern.putAll(nextByPattern);
        removed.forEach(pattern -> this.parents.forEach(parent -> parent.remove((PatternProvider)this, pattern)));
        added.forEach(pattern -> this.parents.forEach(parent -> parent.add((PatternProvider)this, pattern, this.priority)));
    }

    public List<TaskSnapshot> getTaskSnapshots() {
        return this.tasks.getAll().stream().filter(TaskImpl.class::isInstance).map(task -> ((TaskImpl)task).createSnapshot()).toList();
    }

    public void restoreTasks(List<TaskSnapshot> snapshots) {
        this.deferredSnapshots.clear();
        this.deferredSnapshots.addAll(snapshots);
        this.rebuildDeferredTasks();
    }

    private void rebuildDeferredTasks() {
        if (this.deferredSnapshots.isEmpty()) {
            return;
        }
        for (TaskSnapshot snapshot : this.deferredSnapshots) {
            this.tasks.add((Task)new TaskImpl(snapshot), this.network);
        }
        this.deferredSnapshots.clear();
    }

    private Pattern createPattern(ReplicationPatternTemplate template) {
        PatternBuilder builder = PatternBuilder.pattern((PatternType)PatternType.EXTERNAL);
        for (Map.Entry<IMatterType, Long> entry : template.matterCost().entrySet()) {
            ItemStack matterStack = UniversalMatterItem.createMatterStack(entry.getKey(), 1);
            if (matterStack.isEmpty()) {
                LOGGER.warn("Skipping pattern for {} due to missing matter item {}", (Object)template.outputStack(), (Object)entry.getKey().getName());
                return null;
            }
            builder.ingredient((ResourceKey)ItemResource.ofItemStack((ItemStack)matterStack), entry.getValue().longValue());
        }
        ItemStack output = template.outputStack();
        builder.output((ResourceKey)ItemResource.ofItemStack((ItemStack)output), (long)output.getCount());
        UUID patternId = this.blockEntity.getOrCreatePatternId(template.signature());
        PatternLayout layout = builder.buildLayout();
        return new Pattern(patternId, layout);
    }

    public void onAddedIntoContainer(ParentContainer parentContainer) {
        this.parents.add(parentContainer);
        this.tasks.onAddedIntoContainer(parentContainer);
        this.patternsByPattern.keySet().forEach(pattern -> parentContainer.add((PatternProvider)this, pattern, this.priority));
    }

    public void onRemovedFromContainer(ParentContainer parentContainer) {
        this.patternsByPattern.keySet().forEach(pattern -> parentContainer.remove((PatternProvider)this, pattern));
        this.tasks.onRemovedFromContainer(parentContainer);
        this.parents.remove(parentContainer);
    }

    public boolean contains(AutocraftingNetworkComponent component) {
        return false;
    }

    public void addTask(Task task) {
        this.tasks.add(task, this.network);
        this.parents.forEach(parent -> parent.taskAdded((PatternProvider)this, task));
    }

    public void cancelTask(TaskId taskId) {
        this.blockEntity.cancelReplicationTaskForRS2Task(taskId);
        this.tasks.cancel(taskId);
    }

    public List<TaskStatus> getTaskStatuses() {
        return this.tasks.getStatuses();
    }

    @Nullable
    public TaskId peekActiveTaskId() {
        List statuses = this.tasks.getStatuses();
        if (statuses.isEmpty()) {
            return null;
        }
        return ((TaskStatus)statuses.get(statuses.size() - 1)).info().id();
    }

    public long getAmount(ResourceKey resource) {
        return this.tasks.getAmount(resource);
    }

    public void receivedExternalIteration() {
        this.blockEntity.handleExternalIteration();
    }

    public void receivedExternalIteration(Pattern pattern) {
        if (this.network == null) {
            return;
        }
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)this.network.getComponent(AutocraftingNetworkComponent.class);
        if (autocrafting == null) {
            return;
        }
        PatternProvider provider = autocrafting.getProviderByPattern(pattern);
        if (provider != null) {
            provider.receivedExternalIteration();
        }
    }

    public ExternalPatternSink.Result accept(Pattern pattern, Collection<ResourceAmount> resources, Action action) {
        ReplicationPatternInstance instance = this.patternsByPattern.get(pattern);
        if (instance == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        return this.blockEntity.handlePatternRequest(instance.template(), resources, action);
    }

    public ReplicationPatternTemplate getTemplate(Pattern pattern) {
        ReplicationPatternInstance instance = this.patternsByPattern.get(pattern);
        return instance != null ? instance.template() : null;
    }

    private record ReplicationPatternInstance(Pattern pattern, ReplicationPatternTemplate template) {
    }
}

