/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.lifecycle;

import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeBlockEntity;
import com.leclowndu93150.replication_rs2_bridge.block.entity.RepRS2BridgeNetworkNode;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public final class Rs2NodeLifecycle {
    private static final long MAX_RETRY_DELAY = 200L;
    private static final int CONNECTION_CHECK_INTERVAL = 20;
    private final RepRS2BridgeBlockEntity owner;
    private final NetworkNodeContainerProvider containerProvider;
    private final Logger logger;
    private Rs2LifecycleState state = Rs2LifecycleState.IDLE;
    private long retryAtTick = -1L;
    private int attempts;
    private boolean initializationInFlight;
    private boolean rsNodeAttached;
    private int connectionCheckTicks = 0;

    public Rs2NodeLifecycle(RepRS2BridgeBlockEntity owner, NetworkNodeContainerProvider containerProvider, Logger logger) {
        this.owner = owner;
        this.containerProvider = containerProvider;
        this.logger = logger;
    }

    public void requestInitialization(String reason) {
        if (this.canAttemptInitialization()) {
            this.beginInitialization(reason);
        }
    }

    public void resetAfterDataLoad() {
        this.initializationInFlight = false;
        this.attempts = 0;
        this.retryAtTick = -1L;
        this.rsNodeAttached = false;
        if (this.state != Rs2LifecycleState.REMOVED) {
            this.state = Rs2LifecycleState.IDLE;
        }
    }

    public void tick() {
        Level level = this.owner.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        if (this.state == Rs2LifecycleState.WAITING_RETRY) {
            if (this.retryAtTick >= 0L && level.getGameTime() >= this.retryAtTick) {
                this.beginInitialization("retry");
            }
            return;
        }
        if (this.state == Rs2LifecycleState.READY) {
            ++this.connectionCheckTicks;
            if (this.connectionCheckTicks >= 20) {
                this.connectionCheckTicks = 0;
                this.checkConnectionAndReconnect();
            }
        }
    }

    private void checkConnectionAndReconnect() {
        if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
            return;
        }
        RepRS2BridgeNetworkNode networkNode = this.owner.getBridgeNetworkNode();
        if (networkNode == null) {
            this.logger.warn("Bridge: Network node is null, triggering reconnection");
            this.triggerReconnect("null_network_node");
            return;
        }
        Network network = networkNode.getNetwork();
        if (network == null) {
            this.logger.warn("Bridge: Disconnected from RS2 network, triggering reconnection");
            this.triggerReconnect("null_network");
            return;
        }
        this.checkReplicationNetworkConnection();
    }

    private void checkReplicationNetworkConnection() {
        Level level = this.owner.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        try {
            NetworkManager networkManager = NetworkManager.get((Level)level);
            if (networkManager == null) {
                this.logger.warn("Bridge: Replication NetworkManager is null, cannot check connection");
                return;
            }
            NetworkElement element = networkManager.getElement(this.owner.getBlockPos());
            if (element == null) {
                this.logger.warn("Bridge: Disconnected from Replication network, recreating element");
                element = this.owner.createReplicationNetworkElement();
                if (element != null) {
                    networkManager.addElement(element);
                    this.logger.info("Bridge: Replication network element recreated successfully");
                }
                return;
            }
            if (!(element.getNetwork() instanceof MatterNetwork)) {
                this.logger.warn("Bridge: Replication network element exists but not connected to MatterNetwork, re-adding");
                networkManager.removeElement(element.getPos());
                NetworkElement newElement = this.owner.createReplicationNetworkElement();
                if (newElement != null) {
                    networkManager.addElement(newElement);
                    this.logger.info("Bridge: Replication network element re-added successfully");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Bridge: Exception during Replication network check: {}", (Object)e.getMessage());
        }
    }

    private void triggerReconnect(String reason) {
        this.state = Rs2LifecycleState.IDLE;
        this.rsNodeAttached = false;
        this.beginInitialization(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String reason, boolean allowRestart) {
        this.initializationInFlight = false;
        this.attempts = 0;
        this.retryAtTick = -1L;
        if (this.state == Rs2LifecycleState.REMOVED && !allowRestart) {
            return;
        }
        this.state = Rs2LifecycleState.REMOVING;
        Rs2LifecycleState targetState = allowRestart ? Rs2LifecycleState.IDLE : Rs2LifecycleState.REMOVED;
        Level level = this.owner.getLevel();
        if (level != null && !level.isClientSide() && this.rsNodeAttached) {
            try {
                this.containerProvider.remove(level);
            }
            catch (Exception e) {
                this.logger.warn("Bridge: Failed to remove RS2 node during {}: {}", (Object)reason, (Object)e.getMessage());
            }
            finally {
                this.rsNodeAttached = false;
            }
        }
        this.state = targetState;
    }

    public boolean isRemoved() {
        return this.state == Rs2LifecycleState.REMOVED;
    }

    private boolean canAttemptInitialization() {
        if (RepRS2BridgeBlockEntity.isWorldUnloading()) {
            return false;
        }
        Level level = this.owner.getLevel();
        if (level == null || level.isClientSide()) {
            return false;
        }
        if (this.isRemoved() || this.state == Rs2LifecycleState.REMOVING) {
            return false;
        }
        if (this.initializationInFlight) {
            return false;
        }
        if (this.state == Rs2LifecycleState.READY) {
            return false;
        }
        return this.state != Rs2LifecycleState.WAITING_RETRY || this.retryAtTick < 0L || level.getGameTime() >= this.retryAtTick;
    }

    private void beginInitialization(String reason) {
        Level level = this.owner.getLevel();
        if (level == null || level.isClientSide() || this.isRemoved()) {
            return;
        }
        this.initializationInFlight = true;
        this.state = Rs2LifecycleState.INITIALIZING;
        ++this.attempts;
        try {
            this.containerProvider.initialize(level, () -> this.handleInitializationCallback(reason));
        }
        catch (Exception e) {
            this.handleInitializationFailure(reason, e);
        }
    }

    private void handleInitializationCallback(String reason) {
        this.initializationInFlight = false;
        Level level = this.owner.getLevel();
        if (level == null || level.isClientSide() || this.isRemoved() || RepRS2BridgeBlockEntity.isWorldUnloading() || this.state != Rs2LifecycleState.INITIALIZING) {
            return;
        }
        try {
            this.owner.onRsNodeInitializedFromLifecycle();
            this.state = Rs2LifecycleState.READY;
            this.retryAtTick = -1L;
            this.attempts = 0;
            this.rsNodeAttached = true;
        }
        catch (Exception e) {
            this.handleInitializationFailure(reason, e);
        }
    }

    private void handleInitializationFailure(String reason, Exception exception) {
        this.logger.error("Bridge: RS2 node initialization failed ({}): {}", new Object[]{reason, exception.getMessage(), exception});
        this.state = Rs2LifecycleState.WAITING_RETRY;
        this.initializationInFlight = false;
        this.rsNodeAttached = false;
        Level level = this.owner.getLevel();
        if (level != null && !level.isClientSide()) {
            long backoff = 20L * (long)Math.max(1, Math.min(this.attempts, 6));
            this.retryAtTick = level.getGameTime() + Math.min(200L, backoff);
        } else {
            this.retryAtTick = -1L;
        }
    }

    private static enum Rs2LifecycleState {
        IDLE,
        INITIALIZING,
        READY,
        WAITING_RETRY,
        REMOVING,
        REMOVED;

    }
}

