/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.block.entity.task;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskState;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public final class TaskSnapshotNbt {
    private static final String TAG_ID = "Id";
    private static final String TAG_RESOURCE = "Resource";
    private static final String TAG_AMOUNT = "Amount";
    private static final String TAG_ACTOR = "Actor";
    private static final String TAG_NOTIFY_ACTOR = "NotifyActor";
    private static final String TAG_START_TIME = "StartTime";
    private static final String TAG_INITIAL_REQUIREMENTS = "InitialRequirements";
    private static final String TAG_INTERNAL_STORAGE = "InternalStorage";
    private static final String TAG_CANCELLED = "Cancelled";
    private static final String TAG_STATE = "State";
    private static final String TAG_COMPLETED_PATTERNS = "CompletedPatterns";
    private static final String TAG_PATTERNS = "Patterns";
    private static final String TAG_INGREDIENTS = "Ingredients";
    private static final String TAG_OUTPUTS = "Outputs";
    private static final String TAG_BYPRODUCTS = "Byproducts";
    private static final String TAG_PATTERN = "Pattern";
    private static final String TAG_PATTERN_TYPE = "PatternType";
    private static final String TAG_PATTERN_DATA = "PatternData";
    private static final String TAG_INTERNAL = "Internal";
    private static final String TAG_INTERNAL_PATTERN = "InternalPattern";
    private static final String TAG_EXTERNAL_PATTERN = "ExternalPattern";
    private static final String TAG_ROOT = "Root";
    private static final String TAG_INPUTS = "Inputs";
    private static final String TAG_ORIGINAL_ITERATIONS_REMAINING = "OriginalIterationsRemaining";
    private static final String TAG_ITERATIONS_REMAINING = "IterationsRemaining";
    private static final String TAG_EXPECTED_OUTPUTS = "ExpectedOutputs";
    private static final String TAG_SIMULATED_INPUTS = "SimulatedIterationInputs";
    private static final String TAG_ORIGINAL_ITERATIONS_TO_SEND = "OriginalIterationsToSend";
    private static final String TAG_ITERATIONS_TO_SEND = "IterationsToSend";
    private static final String TAG_ITERATIONS_RECEIVED = "IterationsReceived";
    private static final String TAG_INTERCEPTED = "InterceptedSinceLastStep";
    private static final String TAG_LAST_SINK_RESULT = "LastSinkResult";

    private TaskSnapshotNbt() {
    }

    public static CompoundTag encode(TaskSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(TAG_ID, snapshot.id().id());
        tag.put(TAG_RESOURCE, (Tag)TaskSnapshotNbt.encodeResourceKey(snapshot.resource()));
        tag.putLong(TAG_AMOUNT, snapshot.amount());
        Actor actor = snapshot.actor();
        if (actor instanceof PlayerActor) {
            PlayerActor playerActor = (PlayerActor)actor;
            tag.putString(TAG_ACTOR, playerActor.name());
        }
        tag.putBoolean(TAG_NOTIFY_ACTOR, snapshot.notifyActor());
        tag.putLong(TAG_START_TIME, snapshot.startTime());
        tag.put(TAG_INITIAL_REQUIREMENTS, (Tag)TaskSnapshotNbt.encodeResourceList(snapshot.initialRequirements()));
        tag.put(TAG_INTERNAL_STORAGE, (Tag)TaskSnapshotNbt.encodeResourceList(snapshot.internalStorage()));
        tag.putBoolean(TAG_CANCELLED, snapshot.cancelled());
        tag.putString(TAG_STATE, snapshot.state().name());
        ListTag completed = new ListTag();
        snapshot.completedPatterns().forEach(patternSnapshot -> completed.add((Object)TaskSnapshotNbt.encodePatternSnapshot(patternSnapshot)));
        tag.put(TAG_COMPLETED_PATTERNS, (Tag)completed);
        ListTag patterns = new ListTag();
        snapshot.patterns().forEach((pattern, patternSnapshot) -> {
            CompoundTag entry = new CompoundTag();
            entry.put(TAG_PATTERN, (Tag)TaskSnapshotNbt.encodePattern(pattern));
            entry.put(TAG_PATTERN_DATA, (Tag)TaskSnapshotNbt.encodePatternSnapshot(patternSnapshot));
            patterns.add((Object)entry);
        });
        tag.put(TAG_PATTERNS, (Tag)patterns);
        return tag;
    }

    public static TaskSnapshot decode(CompoundTag tag) {
        TaskId id = new TaskId(tag.getUUID(TAG_ID));
        ResourceKey resource = (ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(TAG_RESOURCE)).result().orElseThrow();
        long amount = tag.getLong(TAG_AMOUNT);
        Actor actor = tag.contains(TAG_ACTOR, 8) ? new PlayerActor(tag.getString(TAG_ACTOR)) : Actor.EMPTY;
        boolean notifyActor = tag.getBoolean(TAG_NOTIFY_ACTOR);
        long startTime = tag.getLong(TAG_START_TIME);
        ResourceList initialRequirements = TaskSnapshotNbt.decodeResourceList(tag.getList(TAG_INITIAL_REQUIREMENTS, 10));
        ResourceList internalStorage = TaskSnapshotNbt.decodeResourceList(tag.getList(TAG_INTERNAL_STORAGE, 10));
        boolean cancelled = tag.getBoolean(TAG_CANCELLED);
        TaskState state = TaskState.valueOf((String)tag.getString(TAG_STATE));
        ArrayList<TaskSnapshot.PatternSnapshot> completed = new ArrayList<TaskSnapshot.PatternSnapshot>();
        for (Tag completedTag : tag.getList(TAG_COMPLETED_PATTERNS, 10)) {
            completed.add(TaskSnapshotNbt.decodePatternSnapshot((CompoundTag)completedTag));
        }
        HashMap<Pattern, TaskSnapshot.PatternSnapshot> patterns = new HashMap<Pattern, TaskSnapshot.PatternSnapshot>();
        for (Tag patternTag : tag.getList(TAG_PATTERNS, 10)) {
            CompoundTag entry = (CompoundTag)patternTag;
            Pattern pattern = TaskSnapshotNbt.decodePattern(entry.getCompound(TAG_PATTERN));
            TaskSnapshot.PatternSnapshot snapshot = TaskSnapshotNbt.decodePatternSnapshot(entry.getCompound(TAG_PATTERN_DATA));
            patterns.put(pattern, snapshot);
        }
        return new TaskSnapshot(id, resource, amount, actor, notifyActor, startTime, patterns, completed, initialRequirements, internalStorage, state, cancelled);
    }

    private static ListTag encodeResourceList(ResourceList list) {
        ListTag listTag = new ListTag();
        list.getAll().forEach(resource -> {
            CompoundTag entry = TaskSnapshotNbt.encodeResourceKey(resource);
            entry.putLong(TAG_AMOUNT, list.get(resource));
            listTag.add((Object)entry);
        });
        return listTag;
    }

    private static ResourceList decodeResourceList(ListTag listTag) {
        MutableResourceListImpl resourceList = MutableResourceListImpl.create();
        for (Tag element : listTag) {
            CompoundTag entry = (CompoundTag)element;
            ResourceKey resource = (ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)entry).result().orElseThrow();
            long amount = entry.getLong(TAG_AMOUNT);
            resourceList.add(resource, amount);
        }
        return resourceList;
    }

    private static CompoundTag encodeResourceKey(ResourceKey resource) {
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResourceKey = (PlatformResourceKey)resource;
            Tag encoded = (Tag)ResourceCodecs.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)platformResourceKey).result().orElse(new CompoundTag());
            if (encoded instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)encoded;
                return compoundTag;
            }
            throw new IllegalStateException("Expected CompoundTag while encoding resource key, got: " + encoded.getClass().getSimpleName());
        }
        throw new IllegalStateException("Cannot encode non-platform resource key: " + String.valueOf(resource));
    }

    private static CompoundTag encodePatternSnapshot(TaskSnapshot.PatternSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(TAG_ROOT, snapshot.root());
        tag.put(TAG_PATTERN, (Tag)TaskSnapshotNbt.encodePattern(snapshot.pattern()));
        ListTag ingredients = new ListTag();
        snapshot.ingredients().forEach((slot, inner) -> {
            CompoundTag ingredientTag = new CompoundTag();
            ingredientTag.putInt("Slot", slot.intValue());
            ListTag innerList = new ListTag();
            inner.forEach((resource, amount) -> {
                CompoundTag entry = TaskSnapshotNbt.encodeResourceKey(resource);
                entry.putLong(TAG_AMOUNT, amount.longValue());
                innerList.add((Object)entry);
            });
            ingredientTag.put(TAG_INPUTS, (Tag)innerList);
            ingredients.add((Object)ingredientTag);
        });
        tag.put(TAG_INGREDIENTS, (Tag)ingredients);
        tag.putBoolean(TAG_INTERNAL, snapshot.internalPattern() != null);
        if (snapshot.internalPattern() != null) {
            tag.put(TAG_INTERNAL_PATTERN, (Tag)TaskSnapshotNbt.encodeInternalPattern(snapshot.internalPattern()));
        } else if (snapshot.externalPattern() != null) {
            tag.put(TAG_EXTERNAL_PATTERN, (Tag)TaskSnapshotNbt.encodeExternalPattern(snapshot.externalPattern()));
        }
        return tag;
    }

    private static TaskSnapshot.PatternSnapshot decodePatternSnapshot(CompoundTag tag) {
        boolean root = tag.getBoolean(TAG_ROOT);
        Pattern pattern = TaskSnapshotNbt.decodePattern(tag.getCompound(TAG_PATTERN));
        HashMap ingredients = new HashMap();
        for (Tag ingredientTag : tag.getList(TAG_INGREDIENTS, 10)) {
            CompoundTag ingredient = (CompoundTag)ingredientTag;
            int slot = ingredient.getInt("Slot");
            HashMap<ResourceKey, Long> inner = new HashMap<ResourceKey, Long>();
            for (Tag innerTag : ingredient.getList(TAG_INPUTS, 10)) {
                CompoundTag entry = (CompoundTag)innerTag;
                ResourceKey resource = (ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)entry).result().orElseThrow();
                inner.put(resource, entry.getLong(TAG_AMOUNT));
            }
            ingredients.put(slot, inner);
        }
        if (tag.getBoolean(TAG_INTERNAL)) {
            TaskSnapshot.InternalPatternSnapshot internal = TaskSnapshotNbt.decodeInternalPattern(tag.getCompound(TAG_INTERNAL_PATTERN));
            return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, internal, null);
        }
        TaskSnapshot.ExternalPatternSnapshot external = TaskSnapshotNbt.decodeExternalPattern(tag.getCompound(TAG_EXTERNAL_PATTERN));
        return new TaskSnapshot.PatternSnapshot(root, pattern, ingredients, null, external);
    }

    private static CompoundTag encodePattern(Pattern pattern) {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(TAG_ID, pattern.id());
        ListTag ingredients = new ListTag();
        for (Object ingredient : pattern.layout().ingredients()) {
            ingredients.add((Object)TaskSnapshotNbt.encodeIngredient((Ingredient)ingredient));
        }
        tag.put(TAG_INGREDIENTS, (Tag)ingredients);
        ListTag outputs = new ListTag();
        for (ResourceAmount output : pattern.layout().outputs()) {
            outputs.add((Object)((Tag)ResourceCodecs.AMOUNT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)output).result().orElse(new CompoundTag())));
        }
        tag.put(TAG_OUTPUTS, (Tag)outputs);
        ListTag byproducts = new ListTag();
        for (ResourceAmount byproduct : pattern.layout().byproducts()) {
            byproducts.add((Object)((Tag)ResourceCodecs.AMOUNT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)byproduct).result().orElse(new CompoundTag())));
        }
        tag.put(TAG_BYPRODUCTS, (Tag)byproducts);
        tag.putString(TAG_PATTERN_TYPE, pattern.layout().type().name());
        return tag;
    }

    private static Pattern decodePattern(CompoundTag tag) {
        UUID id = tag.getUUID(TAG_ID);
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (Object ingredientTag : tag.getList(TAG_INGREDIENTS, 10)) {
            ingredients.add(TaskSnapshotNbt.decodeIngredient((CompoundTag)ingredientTag));
        }
        ArrayList<ResourceAmount> outputs = new ArrayList<ResourceAmount>();
        for (Object outputTag : tag.getList(TAG_OUTPUTS, 10)) {
            outputs.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, outputTag).result().orElseThrow());
        }
        ArrayList<ResourceAmount> byproducts = new ArrayList<ResourceAmount>();
        for (Tag byproductTag : tag.getList(TAG_BYPRODUCTS, 10)) {
            byproducts.add((ResourceAmount)ResourceCodecs.AMOUNT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)byproductTag).result().orElseThrow());
        }
        PatternType type = PatternType.valueOf((String)tag.getString(TAG_PATTERN_TYPE));
        PatternLayout layout = type == PatternType.INTERNAL ? PatternLayout.internal(ingredients, outputs, byproducts) : PatternLayout.external(ingredients, outputs);
        return new Pattern(id, layout);
    }

    private static CompoundTag encodeIngredient(Ingredient ingredient) {
        CompoundTag tag = new CompoundTag();
        tag.putLong(TAG_AMOUNT, ingredient.amount());
        ListTag inputs = new ListTag();
        ingredient.inputs().forEach(input -> inputs.add((Object)TaskSnapshotNbt.encodeResourceKey(input)));
        tag.put(TAG_INPUTS, (Tag)inputs);
        return tag;
    }

    private static Ingredient decodeIngredient(CompoundTag tag) {
        long amount = tag.getLong(TAG_AMOUNT);
        ArrayList<ResourceKey> inputs = new ArrayList<ResourceKey>();
        for (Tag inputTag : tag.getList(TAG_INPUTS, 10)) {
            inputs.add((ResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)inputTag).result().orElseThrow());
        }
        return new Ingredient(amount, inputs);
    }

    private static CompoundTag encodeInternalPattern(TaskSnapshot.InternalPatternSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.putLong(TAG_ORIGINAL_ITERATIONS_REMAINING, snapshot.originalIterationsRemaining());
        tag.putLong(TAG_ITERATIONS_REMAINING, snapshot.iterationsRemaining());
        return tag;
    }

    private static TaskSnapshot.InternalPatternSnapshot decodeInternalPattern(CompoundTag tag) {
        long original = tag.getLong(TAG_ORIGINAL_ITERATIONS_REMAINING);
        long remaining = tag.getLong(TAG_ITERATIONS_REMAINING);
        return new TaskSnapshot.InternalPatternSnapshot(original, remaining);
    }

    private static CompoundTag encodeExternalPattern(TaskSnapshot.ExternalPatternSnapshot snapshot) {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_EXPECTED_OUTPUTS, (Tag)TaskSnapshotNbt.encodeResourceList(snapshot.expectedOutputs()));
        tag.put(TAG_SIMULATED_INPUTS, (Tag)TaskSnapshotNbt.encodeResourceList(snapshot.simulatedIterationInputs()));
        tag.putLong(TAG_ORIGINAL_ITERATIONS_TO_SEND, snapshot.originalIterationsToSendToSink());
        tag.putLong(TAG_ITERATIONS_TO_SEND, snapshot.iterationsToSendToSink());
        tag.putLong(TAG_ITERATIONS_RECEIVED, snapshot.iterationsReceived());
        tag.putBoolean(TAG_INTERCEPTED, snapshot.interceptedAnythingSinceLastStep());
        if (snapshot.lastSinkResult() != null) {
            tag.putString(TAG_LAST_SINK_RESULT, snapshot.lastSinkResult().name());
        }
        return tag;
    }

    private static TaskSnapshot.ExternalPatternSnapshot decodeExternalPattern(CompoundTag tag) {
        ResourceList expectedOutputs = TaskSnapshotNbt.decodeResourceList(tag.getList(TAG_EXPECTED_OUTPUTS, 10));
        ResourceList simulatedInputs = TaskSnapshotNbt.decodeResourceList(tag.getList(TAG_SIMULATED_INPUTS, 10));
        long originalIterationsToSend = tag.getLong(TAG_ORIGINAL_ITERATIONS_TO_SEND);
        long iterationsToSend = tag.getLong(TAG_ITERATIONS_TO_SEND);
        long iterationsReceived = tag.getLong(TAG_ITERATIONS_RECEIVED);
        boolean intercepted = tag.getBoolean(TAG_INTERCEPTED);
        ExternalPatternSink.Result sinkResult = tag.contains(TAG_LAST_SINK_RESULT) ? ExternalPatternSink.Result.valueOf((String)tag.getString(TAG_LAST_SINK_RESULT)) : null;
        return new TaskSnapshot.ExternalPatternSnapshot(expectedOutputs, simulatedInputs, originalIterationsToSend, iterationsToSend, iterationsReceived, intercepted, sinkResult, null);
    }
}

