/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.item;

import com.buuz135.replication.api.IMatterType;
import com.leclowndu93150.replication_rs2_bridge.component.MatterComponent;
import com.leclowndu93150.replication_rs2_bridge.component.ModDataComponents;
import com.leclowndu93150.replication_rs2_bridge.item.ModItems;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeInfo;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class UniversalMatterItem
extends Item {
    public UniversalMatterItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player && !level.isClientSide()) {
            stack.setCount(0);
        }
    }

    public Component getName(ItemStack stack) {
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null) {
            String matterName = component.matterTypeName();
            String capitalizedName = matterName.substring(0, 1).toUpperCase() + matterName.substring(1);
            return Component.literal((String)(capitalizedName + " Matter"));
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MatterTypeInfo info;
        MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
        if (component != null && (info = MatterTypeUtil.getMatterInfo(component.matterTypeName())) != null && !info.registryId().getNamespace().equals("replication")) {
            tooltipComponents.add((Component)Component.literal((String)("From: " + info.registryId().getNamespace())).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack createMatterStack(IMatterType matterType, int count) {
        MatterComponent component;
        MatterTypeInfo info = MatterTypeUtil.getMatterInfo(matterType);
        if (info != null && info.canonicalComponent() != null) {
            component = info.canonicalComponent();
        } else {
            String name = matterType.getName();
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"replication", (String)("gui/mattertypes/" + name.toLowerCase()));
            component = new MatterComponent(name, texture);
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.UNIVERSAL_MATTER.get(), count);
        stack.set((DataComponentType)ModDataComponents.MATTER.get(), (Object)component);
        return stack;
    }
}

