/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.storage;

import com.leclowndu93150.replication_rs2_bridge.block.entity.pattern.PatternSignature;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BridgePatternRepository
extends SavedData {
    public static final String NAME = "replication_rs2_bridge_patterns";
    private static final String TAG_BRIDGES = "Bridges";
    private static final String TAG_BRIDGE_ID = "BridgeId";
    private static final String TAG_PATTERNS = "Patterns";
    private static final String TAG_PATTERN_ID = "PatternId";
    private final Map<UUID, Map<PatternSignature, UUID>> bridgePatterns = new HashMap<UUID, Map<PatternSignature, UUID>>();

    public BridgePatternRepository() {
    }

    public BridgePatternRepository(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_BRIDGES, 9)) {
            ListTag bridgesList = tag.getList(TAG_BRIDGES, 10);
            for (Tag bridgeTag : bridgesList) {
                CompoundTag bridgeCompound = (CompoundTag)bridgeTag;
                UUID bridgeId = bridgeCompound.getUUID(TAG_BRIDGE_ID);
                HashMap<PatternSignature, UUID> patterns = new HashMap<PatternSignature, UUID>();
                if (bridgeCompound.contains(TAG_PATTERNS, 9)) {
                    ListTag patternsList = bridgeCompound.getList(TAG_PATTERNS, 10);
                    for (Tag patternTag : patternsList) {
                        CompoundTag patternCompound = (CompoundTag)patternTag;
                        PatternSignature signature = PatternSignature.load(patternCompound);
                        UUID patternId = patternCompound.getUUID(TAG_PATTERN_ID);
                        patterns.put(signature, patternId);
                    }
                }
                this.bridgePatterns.put(bridgeId, patterns);
            }
        }
    }

    public Map<PatternSignature, UUID> getPatternsForBridge(UUID blockId) {
        return this.bridgePatterns.computeIfAbsent(blockId, k -> new HashMap());
    }

    public void setPatternsForBridge(UUID blockId, Map<PatternSignature, UUID> patterns) {
        this.bridgePatterns.put(blockId, new HashMap<PatternSignature, UUID>(patterns));
        this.setDirty();
    }

    public void removeBridge(UUID blockId) {
        if (this.bridgePatterns.remove(blockId) != null) {
            this.setDirty();
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag bridgesList = new ListTag();
        for (Map.Entry<UUID, Map<PatternSignature, UUID>> bridgeEntry : this.bridgePatterns.entrySet()) {
            if (bridgeEntry.getValue().isEmpty()) continue;
            CompoundTag bridgeCompound = BridgePatternRepository.getCompoundTag(bridgeEntry);
            bridgesList.add((Object)bridgeCompound);
        }
        tag.put(TAG_BRIDGES, (Tag)bridgesList);
        return tag;
    }

    @NotNull
    private static CompoundTag getCompoundTag(Map.Entry<UUID, Map<PatternSignature, UUID>> bridgeEntry) {
        CompoundTag bridgeCompound = new CompoundTag();
        bridgeCompound.putUUID(TAG_BRIDGE_ID, bridgeEntry.getKey());
        ListTag patternsList = new ListTag();
        for (Map.Entry<PatternSignature, UUID> patternEntry : bridgeEntry.getValue().entrySet()) {
            CompoundTag patternCompound = patternEntry.getKey().save();
            patternCompound.putUUID(TAG_PATTERN_ID, patternEntry.getValue());
            patternsList.add((Object)patternCompound);
        }
        bridgeCompound.put(TAG_PATTERNS, (Tag)patternsList);
        return bridgeCompound;
    }
}

